/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.streaming.tools;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli2.CommandLine;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.builder.ArgumentBuilder;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.commons.cli2.builder.GroupBuilder;
import org.apache.commons.cli2.commandline.Parser;
import org.apache.commons.cli2.option.DefaultOption;
import org.apache.commons.cli2.util.HelpFormatter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.mahout.clustering.ClusteringUtils;
import org.apache.mahout.clustering.iterator.ClusterWritable;
import org.apache.mahout.clustering.streaming.mapreduce.CentroidWritable;
import org.apache.mahout.clustering.streaming.tools.IOUtils;
import org.apache.mahout.common.AbstractJob;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.common.distance.SquaredEuclideanDistanceMeasure;
import org.apache.mahout.common.iterator.sequencefile.PathType;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileDirValueIterable;
import org.apache.mahout.math.Centroid;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.stats.OnlineSummarizer;

public class ClusterQualitySummarizer
extends AbstractJob {
    private String outputFile;
    private PrintWriter fileOut;
    private String trainFile;
    private String testFile;
    private String centroidFile;
    private String centroidCompareFile;
    private boolean mahoutKMeansFormat;
    private boolean mahoutKMeansFormatCompare;
    private DistanceMeasure distanceMeasure = new SquaredEuclideanDistanceMeasure();

    public void printSummaries(List<OnlineSummarizer> summarizers, String type) {
        ClusterQualitySummarizer.printSummaries(summarizers, type, this.fileOut);
    }

    public static void printSummaries(List<OnlineSummarizer> summarizers, String type, PrintWriter fileOut) {
        double maxDistance = 0.0;
        for (int i = 0; i < summarizers.size(); ++i) {
            OnlineSummarizer summarizer = summarizers.get(i);
            if (summarizer.getCount() > 1) {
                maxDistance = Math.max(maxDistance, summarizer.getMax());
                System.out.printf("Average distance in cluster %d [%d]: %f\n", i, summarizer.getCount(), summarizer.getMean());
                if (fileOut == null) continue;
                fileOut.printf("%d,%f,%f,%f,%f,%f,%f,%f,%d,%s\n", i, summarizer.getMean(), summarizer.getSD(), summarizer.getQuartile(0), summarizer.getQuartile(1), summarizer.getQuartile(2), summarizer.getQuartile(3), summarizer.getQuartile(4), summarizer.getCount(), type);
                continue;
            }
            System.out.printf("Cluster %d is has %d data point. Need atleast 2 data points in a cluster for OnlineSummarizer.\n", i, summarizer.getCount());
        }
        System.out.printf("Num clusters: %d; maxDistance: %f\n", summarizers.size(), maxDistance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int run(String[] args) throws IOException {
        if (!this.parseArgs(args)) {
            return -1;
        }
        Configuration conf = new Configuration();
        try {
            Iterable<Vector> trainDatapoints;
            ArrayList<Centroid> centroids;
            this.fileOut = new PrintWriter(new FileOutputStream(this.outputFile));
            this.fileOut.printf("cluster,distance.mean,distance.sd,distance.q0,distance.q1,distance.q2,distance.q3,distance.q4,count,is.train\n", new Object[0]);
            ArrayList<Centroid> centroidsCompare = null;
            if (this.mahoutKMeansFormat) {
                SequenceFileDirValueIterable<ClusterWritable> clusterIterable = new SequenceFileDirValueIterable<ClusterWritable>(new Path(this.centroidFile), PathType.GLOB, conf);
                centroids = Lists.newArrayList(IOUtils.getCentroidsFromClusterWritableIterable(clusterIterable));
            } else {
                SequenceFileDirValueIterable<CentroidWritable> centroidIterable = new SequenceFileDirValueIterable<CentroidWritable>(new Path(this.centroidFile), PathType.GLOB, conf);
                centroids = Lists.newArrayList(IOUtils.getCentroidsFromCentroidWritableIterable(centroidIterable));
            }
            if (this.centroidCompareFile != null) {
                if (this.mahoutKMeansFormatCompare) {
                    SequenceFileDirValueIterable<ClusterWritable> clusterCompareIterable = new SequenceFileDirValueIterable<ClusterWritable>(new Path(this.centroidCompareFile), PathType.GLOB, conf);
                    centroidsCompare = Lists.newArrayList(IOUtils.getCentroidsFromClusterWritableIterable(clusterCompareIterable));
                } else {
                    SequenceFileDirValueIterable<CentroidWritable> centroidCompareIterable = new SequenceFileDirValueIterable<CentroidWritable>(new Path(this.centroidCompareFile), PathType.GLOB, conf);
                    centroidsCompare = Lists.newArrayList(IOUtils.getCentroidsFromCentroidWritableIterable(centroidCompareIterable));
                }
            }
            SequenceFileDirValueIterable<VectorWritable> trainIterable = new SequenceFileDirValueIterable<VectorWritable>(new Path(this.trainFile), PathType.GLOB, conf);
            Iterable<Vector> datapoints = trainDatapoints = IOUtils.getVectorsFromVectorWritableIterable(trainIterable);
            this.printSummaries(ClusteringUtils.summarizeClusterDistances(trainDatapoints, centroids, new SquaredEuclideanDistanceMeasure()), "train");
            if (this.testFile != null) {
                SequenceFileDirValueIterable<VectorWritable> testIterable = new SequenceFileDirValueIterable<VectorWritable>(new Path(this.testFile), PathType.GLOB, conf);
                Iterable<Vector> testDatapoints = IOUtils.getVectorsFromVectorWritableIterable(testIterable);
                this.printSummaries(ClusteringUtils.summarizeClusterDistances(testDatapoints, centroids, new SquaredEuclideanDistanceMeasure()), "test");
                datapoints = Iterables.concat(trainDatapoints, testDatapoints);
            }
            List<OnlineSummarizer> summaries = ClusteringUtils.summarizeClusterDistances(datapoints, centroids, this.distanceMeasure);
            List<OnlineSummarizer> compareSummaries = null;
            if (centroidsCompare != null) {
                compareSummaries = ClusteringUtils.summarizeClusterDistances(datapoints, centroidsCompare, this.distanceMeasure);
            }
            System.out.printf("[Dunn Index] First: %f", ClusteringUtils.dunnIndex(centroids, this.distanceMeasure, summaries));
            if (compareSummaries != null) {
                System.out.printf(" Second: %f\n", ClusteringUtils.dunnIndex(centroidsCompare, this.distanceMeasure, compareSummaries));
            } else {
                System.out.printf("\n", new Object[0]);
            }
            System.out.printf("[Davies-Bouldin Index] First: %f", ClusteringUtils.daviesBouldinIndex(centroids, this.distanceMeasure, summaries));
            if (compareSummaries != null) {
                System.out.printf(" Second: %f\n", ClusteringUtils.daviesBouldinIndex(centroidsCompare, this.distanceMeasure, compareSummaries));
            } else {
                System.out.printf("\n", new Object[0]);
            }
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
        finally {
            Closeables.close(this.fileOut, false);
        }
        return 0;
    }

    private boolean parseArgs(String[] args) {
        DefaultOptionBuilder builder = new DefaultOptionBuilder();
        DefaultOption help = builder.withLongName("help").withDescription("print this list").create();
        ArgumentBuilder argumentBuilder = new ArgumentBuilder();
        DefaultOption inputFileOption = builder.withLongName("input").withShortName("i").withRequired(true).withArgument(argumentBuilder.withName("input").withMaximum(1).create()).withDescription("where to get seq files with the vectors (training set)").create();
        DefaultOption testInputFileOption = builder.withLongName("testInput").withShortName("itest").withArgument(argumentBuilder.withName("testInput").withMaximum(1).create()).withDescription("where to get seq files with the vectors (test set)").create();
        DefaultOption centroidsFileOption = builder.withLongName("centroids").withShortName("c").withRequired(true).withArgument(argumentBuilder.withName("centroids").withMaximum(1).create()).withDescription("where to get seq files with the centroids (from Mahout KMeans or StreamingKMeansDriver)").create();
        DefaultOption centroidsCompareFileOption = builder.withLongName("centroidsCompare").withShortName("cc").withRequired(false).withArgument(argumentBuilder.withName("centroidsCompare").withMaximum(1).create()).withDescription("where to get seq files with the second set of centroids (from Mahout KMeans or StreamingKMeansDriver)").create();
        DefaultOption outputFileOption = builder.withLongName("output").withShortName("o").withRequired(true).withArgument(argumentBuilder.withName("output").withMaximum(1).create()).withDescription("where to dump the CSV file with the results").create();
        DefaultOption mahoutKMeansFormatOption = builder.withLongName("mahoutkmeansformat").withShortName("mkm").withDescription("if set, read files as (IntWritable, ClusterWritable) pairs").withArgument(argumentBuilder.withName("numpoints").withMaximum(1).create()).create();
        DefaultOption mahoutKMeansCompareFormatOption = builder.withLongName("mahoutkmeansformatCompare").withShortName("mkmc").withDescription("if set, read files as (IntWritable, ClusterWritable) pairs").withArgument(argumentBuilder.withName("numpoints").withMaximum(1).create()).create();
        Group normalArgs = new GroupBuilder().withOption(help).withOption(inputFileOption).withOption(testInputFileOption).withOption(outputFileOption).withOption(centroidsFileOption).withOption(centroidsCompareFileOption).withOption(mahoutKMeansFormatOption).withOption(mahoutKMeansCompareFormatOption).create();
        Parser parser = new Parser();
        parser.setHelpOption(help);
        parser.setHelpTrigger("--help");
        parser.setGroup(normalArgs);
        parser.setHelpFormatter(new HelpFormatter(" ", "", " ", 150));
        CommandLine cmdLine = parser.parseAndHelp(args);
        if (cmdLine == null) {
            return false;
        }
        this.trainFile = (String)cmdLine.getValue(inputFileOption);
        if (cmdLine.hasOption(testInputFileOption)) {
            this.testFile = (String)cmdLine.getValue(testInputFileOption);
        }
        this.centroidFile = (String)cmdLine.getValue(centroidsFileOption);
        if (cmdLine.hasOption(centroidsCompareFileOption)) {
            this.centroidCompareFile = (String)cmdLine.getValue(centroidsCompareFileOption);
        }
        this.outputFile = (String)cmdLine.getValue(outputFileOption);
        if (cmdLine.hasOption(mahoutKMeansFormatOption)) {
            this.mahoutKMeansFormat = true;
        }
        if (cmdLine.hasOption(mahoutKMeansCompareFormatOption)) {
            this.mahoutKMeansFormatCompare = true;
        }
        return true;
    }

    public static void main(String[] args) throws IOException {
        new ClusterQualitySummarizer().run(args);
    }
}

