/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.spectral;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.mahout.clustering.spectral.IntDoublePairWritable;
import org.apache.mahout.clustering.spectral.VectorCache;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public final class MatrixDiagonalizeJob {
    private MatrixDiagonalizeJob() {
    }

    public static Vector runJob(Path affInput, int dimensions) throws IOException, ClassNotFoundException, InterruptedException {
        Configuration conf = new Configuration();
        Path diagOutput = new Path(affInput.getParent(), "diagonal");
        HadoopUtil.delete(conf, diagOutput);
        conf.setInt("org.apache.mahout.clustering.spectral.common.affinitydimensions", dimensions);
        Job job = new Job(conf, "MatrixDiagonalizeJob");
        job.setInputFormatClass(SequenceFileInputFormat.class);
        job.setMapOutputKeyClass(NullWritable.class);
        job.setMapOutputValueClass(IntDoublePairWritable.class);
        job.setOutputKeyClass(NullWritable.class);
        job.setOutputValueClass(VectorWritable.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        job.setMapperClass(MatrixDiagonalizeMapper.class);
        job.setReducerClass(MatrixDiagonalizeReducer.class);
        FileInputFormat.addInputPath(job, affInput);
        FileOutputFormat.setOutputPath(job, diagOutput);
        job.setJarByClass(MatrixDiagonalizeJob.class);
        boolean succeeded = job.waitForCompletion(true);
        if (!succeeded) {
            throw new IllegalStateException("Job failed!");
        }
        return VectorCache.load(conf, new Path(diagOutput, "part-r-00000"));
    }

    public static class MatrixDiagonalizeReducer
    extends Reducer<NullWritable, IntDoublePairWritable, NullWritable, VectorWritable> {
        @Override
        protected void reduce(NullWritable key, Iterable<IntDoublePairWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            DenseVector retval = new DenseVector(context.getConfiguration().getInt("org.apache.mahout.clustering.spectral.common.affinitydimensions", Integer.MAX_VALUE));
            for (IntDoublePairWritable e : values) {
                retval.setQuick(e.getKey(), e.getValue());
            }
            context.write(key, new VectorWritable(retval));
        }
    }

    public static class MatrixDiagonalizeMapper
    extends Mapper<IntWritable, VectorWritable, NullWritable, IntDoublePairWritable> {
        @Override
        protected void map(IntWritable key, VectorWritable row, Mapper.Context context) throws IOException, InterruptedException {
            IntDoublePairWritable store = new IntDoublePairWritable(key.get(), row.get().zSum());
            context.write(NullWritable.get(), store);
        }
    }
}

