/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.kmeans;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.clustering.Cluster;
import org.apache.mahout.clustering.classify.ClusterClassificationDriver;
import org.apache.mahout.clustering.classify.ClusterClassifier;
import org.apache.mahout.clustering.iterator.ClusterIterator;
import org.apache.mahout.clustering.iterator.KMeansClusteringPolicy;
import org.apache.mahout.clustering.kmeans.KMeansUtil;
import org.apache.mahout.clustering.kmeans.RandomSeedGenerator;
import org.apache.mahout.common.AbstractJob;
import org.apache.mahout.common.ClassUtils;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.commandline.DefaultOptionCreator;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.common.distance.SquaredEuclideanDistanceMeasure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KMeansDriver
extends AbstractJob {
    private static final Logger log = LoggerFactory.getLogger(KMeansDriver.class);

    public static void main(String[] args) throws Exception {
        ToolRunner.run(new Configuration(), new KMeansDriver(), args);
    }

    @Override
    public int run(String[] args) throws Exception {
        this.addInputOption();
        this.addOutputOption();
        this.addOption(DefaultOptionCreator.distanceMeasureOption().create());
        this.addOption(DefaultOptionCreator.clustersInOption().withDescription("The input centroids, as Vectors.  Must be a SequenceFile of Writable, Cluster/Canopy.  If k is also specified, then a random set of vectors will be selected and written out to this path first").create());
        this.addOption(DefaultOptionCreator.numClustersOption().withDescription("The k in k-Means.  If specified, then a random selection of k Vectors will be chosen as the Centroid and written to the clusters input path.").create());
        this.addOption(DefaultOptionCreator.convergenceOption().create());
        this.addOption(DefaultOptionCreator.maxIterationsOption().create());
        this.addOption(DefaultOptionCreator.overwriteOption().create());
        this.addOption(DefaultOptionCreator.clusteringOption().create());
        this.addOption(DefaultOptionCreator.methodOption().create());
        this.addOption(DefaultOptionCreator.outlierThresholdOption().create());
        if (this.parseArguments(args) == null) {
            return -1;
        }
        Path input = this.getInputPath();
        Path clusters = new Path(this.getOption("clusters"));
        Path output = this.getOutputPath();
        String measureClass = this.getOption("distanceMeasure");
        if (measureClass == null) {
            measureClass = SquaredEuclideanDistanceMeasure.class.getName();
        }
        double convergenceDelta = Double.parseDouble(this.getOption("convergenceDelta"));
        int maxIterations = Integer.parseInt(this.getOption("maxIter"));
        if (this.hasOption("overwrite")) {
            HadoopUtil.delete(this.getConf(), output);
        }
        DistanceMeasure measure = ClassUtils.instantiateAs(measureClass, DistanceMeasure.class);
        if (this.hasOption("numClusters")) {
            clusters = RandomSeedGenerator.buildRandom(this.getConf(), input, clusters, Integer.parseInt(this.getOption("numClusters")), measure);
        }
        boolean runClustering = this.hasOption("clustering");
        boolean runSequential = this.getOption("method").equalsIgnoreCase("sequential");
        double clusterClassificationThreshold = 0.0;
        if (this.hasOption("outlierThreshold")) {
            clusterClassificationThreshold = Double.parseDouble(this.getOption("outlierThreshold"));
        }
        KMeansDriver.run(this.getConf(), input, clusters, output, convergenceDelta, maxIterations, runClustering, clusterClassificationThreshold, runSequential);
        return 0;
    }

    public static void run(Configuration conf, Path input, Path clustersIn, Path output, double convergenceDelta, int maxIterations, boolean runClustering, double clusterClassificationThreshold, boolean runSequential) throws IOException, InterruptedException, ClassNotFoundException {
        String delta = Double.toString(convergenceDelta);
        if (log.isInfoEnabled()) {
            log.info("Input: {} Clusters In: {} Out: {}", new Object[]{input, clustersIn, output});
            log.info("convergence: {} max Iterations: {}", (Object)convergenceDelta, (Object)maxIterations);
        }
        Path clustersOut = KMeansDriver.buildClusters(conf, input, clustersIn, output, maxIterations, delta, runSequential);
        if (runClustering) {
            log.info("Clustering data");
            KMeansDriver.clusterData(conf, input, clustersOut, output, clusterClassificationThreshold, runSequential);
        }
    }

    public static void run(Path input, Path clustersIn, Path output, double convergenceDelta, int maxIterations, boolean runClustering, double clusterClassificationThreshold, boolean runSequential) throws IOException, InterruptedException, ClassNotFoundException {
        KMeansDriver.run(new Configuration(), input, clustersIn, output, convergenceDelta, maxIterations, runClustering, clusterClassificationThreshold, runSequential);
    }

    public static Path buildClusters(Configuration conf, Path input, Path clustersIn, Path output, int maxIterations, String delta, boolean runSequential) throws IOException, InterruptedException, ClassNotFoundException {
        double convergenceDelta = Double.parseDouble(delta);
        ArrayList<Cluster> clusters = Lists.newArrayList();
        KMeansUtil.configureWithClusterInfo(conf, clustersIn, clusters);
        if (clusters.isEmpty()) {
            throw new IllegalStateException("No input clusters found in " + clustersIn + ". Check your -c argument.");
        }
        Path priorClustersPath = new Path(output, "clusters-0");
        KMeansClusteringPolicy policy = new KMeansClusteringPolicy(convergenceDelta);
        ClusterClassifier prior = new ClusterClassifier(clusters, policy);
        prior.writeToSeqFiles(priorClustersPath);
        if (runSequential) {
            ClusterIterator.iterateSeq(conf, input, priorClustersPath, output, maxIterations);
        } else {
            ClusterIterator.iterateMR(conf, input, priorClustersPath, output, maxIterations);
        }
        return output;
    }

    public static void clusterData(Configuration conf, Path input, Path clustersIn, Path output, double clusterClassificationThreshold, boolean runSequential) throws IOException, InterruptedException, ClassNotFoundException {
        if (log.isInfoEnabled()) {
            log.info("Running Clustering");
            log.info("Input: {} Clusters In: {} Out: {}", new Object[]{input, clustersIn, output});
        }
        ClusterClassifier.writePolicy(new KMeansClusteringPolicy(), clustersIn);
        ClusterClassificationDriver.run(conf, input, output, new Path(output, "clusteredPoints"), clusterClassificationThreshold, true, runSequential);
    }
}

