/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.iterator;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.clustering.Cluster;
import org.apache.mahout.clustering.classify.ClusterClassifier;
import org.apache.mahout.clustering.iterator.ClusterWritable;
import org.apache.mahout.clustering.iterator.ClusteringPolicy;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public class CIMapper
extends Mapper<WritableComparable<?>, VectorWritable, IntWritable, ClusterWritable> {
    private ClusterClassifier classifier;
    private ClusteringPolicy policy;

    @Override
    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        String priorClustersPath = conf.get("org.apache.mahout.clustering.prior.path");
        this.classifier = new ClusterClassifier();
        this.classifier.readFromSeqFiles(conf, new Path(priorClustersPath));
        this.policy = this.classifier.getPolicy();
        this.policy.update(this.classifier);
        super.setup(context);
    }

    @Override
    protected void map(WritableComparable<?> key, VectorWritable value, Mapper.Context context) throws IOException, InterruptedException {
        Vector probabilities = this.classifier.classify(value.get());
        Vector selections = this.policy.select(probabilities);
        for (Vector.Element el : selections.nonZeroes()) {
            this.classifier.train(el.index(), value.get(), el.get());
        }
    }

    @Override
    protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
        List<Cluster> clusters = this.classifier.getModels();
        ClusterWritable cw = new ClusterWritable();
        for (int index = 0; index < clusters.size(); ++index) {
            cw.setValue(clusters.get(index));
            context.write(new IntWritable(index), cw);
        }
        super.cleanup(context);
    }
}

