/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.iterator;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.mahout.clustering.Cluster;
import org.apache.mahout.clustering.classify.ClusterClassifier;
import org.apache.mahout.clustering.iterator.ClusteringPolicy;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.SequentialAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.function.TimesFunction;

public abstract class AbstractClusteringPolicy
implements ClusteringPolicy {
    @Override
    public abstract void write(DataOutput var1) throws IOException;

    @Override
    public abstract void readFields(DataInput var1) throws IOException;

    @Override
    public Vector select(Vector probabilities) {
        int maxValueIndex = probabilities.maxValueIndex();
        SequentialAccessSparseVector weights = new SequentialAccessSparseVector(probabilities.size());
        weights.set(maxValueIndex, 1.0);
        return weights;
    }

    @Override
    public void update(ClusterClassifier posterior) {
    }

    @Override
    public Vector classify(Vector data, ClusterClassifier prior) {
        List<Cluster> models = prior.getModels();
        int i = 0;
        DenseVector pdfs = new DenseVector(models.size());
        for (Cluster model : models) {
            pdfs.set(i++, model.pdf(new VectorWritable(data)));
        }
        return pdfs.assign(new TimesFunction(), 1.0 / pdfs.zSum());
    }

    @Override
    public void close(ClusterClassifier posterior) {
        for (Cluster cluster : posterior.getModels()) {
            cluster.computeParameters();
        }
    }
}

