/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.evaluation;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.mahout.clustering.classify.WeightedVectorWritable;
import org.apache.mahout.clustering.evaluation.RepresentativePointsMapper;
import org.apache.mahout.math.VectorWritable;

public class RepresentativePointsReducer
extends Reducer<IntWritable, WeightedVectorWritable, IntWritable, VectorWritable> {
    private Map<Integer, List<VectorWritable>> representativePoints;

    @Override
    protected void cleanup(Reducer.Context context) throws IOException, InterruptedException {
        for (Map.Entry<Integer, List<VectorWritable>> entry : this.representativePoints.entrySet()) {
            IntWritable iw = new IntWritable(entry.getKey());
            for (VectorWritable vw : entry.getValue()) {
                context.write(iw, vw);
            }
        }
        super.cleanup(context);
    }

    @Override
    protected void reduce(IntWritable key, Iterable<WeightedVectorWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        WeightedVectorWritable mdp = null;
        for (WeightedVectorWritable dpw : values) {
            if (mdp != null && !(mdp.getWeight() < dpw.getWeight())) continue;
            mdp = new WeightedVectorWritable(dpw.getWeight(), dpw.getVector());
        }
        context.write(new IntWritable(key.get()), new VectorWritable(mdp.getVector()));
    }

    @Override
    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        super.setup(context);
        Configuration conf = context.getConfiguration();
        this.representativePoints = RepresentativePointsMapper.getRepresentativePoints(conf);
    }

    public void configure(Map<Integer, List<VectorWritable>> representativePoints) {
        this.representativePoints = representativePoints;
    }
}

