/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.display;

import com.google.common.base.Charsets;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.BufferedWriter;
import java.io.File;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.mahout.clustering.display.DisplayClustering;
import org.apache.mahout.clustering.spectral.kmeans.SpectralKMeansDriver;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.distance.ManhattanDistanceMeasure;
import org.apache.mahout.math.VectorWritable;

public class DisplaySpectralKMeans
extends DisplayClustering {
    protected static final String SAMPLES = "samples";
    protected static final String OUTPUT = "output";
    protected static final String TEMP = "tmp";
    protected static final String AFFINITIES = "affinities";

    DisplaySpectralKMeans() {
        this.initialize();
        this.setTitle("Spectral k-Means Clusters (>" + (int)(significance * 100.0) + "% of population)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        ManhattanDistanceMeasure measure = new ManhattanDistanceMeasure();
        Path samples = new Path(SAMPLES);
        Path output = new Path(OUTPUT);
        Path tempDir = new Path(TEMP);
        Configuration conf = new Configuration();
        HadoopUtil.delete(conf, samples);
        HadoopUtil.delete(conf, output);
        RandomUtils.useTestSeed();
        DisplayClustering.generateSamples();
        DisplaySpectralKMeans.writeSampleData(samples);
        Path affinities = new Path(output, AFFINITIES);
        FileSystem fs = FileSystem.get(output.toUri(), conf);
        if (!fs.exists(output)) {
            fs.mkdirs(output);
        }
        BufferedWriter writer = null;
        try {
            writer = Files.newWriter(new File(affinities.toString()), Charsets.UTF_8);
            for (int i = 0; i < SAMPLE_DATA.size(); ++i) {
                for (int j = 0; j < SAMPLE_DATA.size(); ++j) {
                    writer.write(i + "," + j + ',' + measure.distance(((VectorWritable)SAMPLE_DATA.get(i)).get(), ((VectorWritable)SAMPLE_DATA.get(j)).get()) + '\n');
                }
            }
        }
        catch (Throwable throwable) {
            Closeables.close(writer, false);
            throw throwable;
        }
        Closeables.close(writer, false);
        int maxIter = 10;
        double convergenceDelta = 0.001;
        SpectralKMeansDriver.run(new Configuration(), affinities, output, SAMPLE_DATA.size(), 3, measure, convergenceDelta, maxIter, tempDir, false);
        new DisplaySpectralKMeans();
    }

    @Override
    public void paint(Graphics g) {
        DisplaySpectralKMeans.plotClusteredSampleData((Graphics2D)g, new Path(OUTPUT));
    }
}

