/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.classify;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.clustering.Cluster;
import org.apache.mahout.clustering.classify.ClusterClassifier;
import org.apache.mahout.clustering.classify.WeightedPropertyVectorWritable;
import org.apache.mahout.clustering.classify.WeightedVectorWritable;
import org.apache.mahout.clustering.iterator.ClusterWritable;
import org.apache.mahout.clustering.iterator.ClusteringPolicy;
import org.apache.mahout.clustering.iterator.DistanceMeasureCluster;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.common.iterator.sequencefile.PathFilters;
import org.apache.mahout.common.iterator.sequencefile.PathType;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileDirValueIterator;
import org.apache.mahout.math.NamedVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public class ClusterClassificationMapper
extends Mapper<WritableComparable<?>, VectorWritable, IntWritable, WeightedVectorWritable> {
    private double threshold;
    private List<Cluster> clusterModels;
    private ClusterClassifier clusterClassifier;
    private IntWritable clusterId;
    private boolean emitMostLikely;

    @Override
    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        Configuration conf = context.getConfiguration();
        String clustersIn = conf.get("clusters_in");
        this.threshold = conf.getFloat("pdf_threshold", 0.0f);
        this.emitMostLikely = conf.getBoolean("emit_most_likely", false);
        this.clusterModels = Lists.newArrayList();
        if (clustersIn != null && !clustersIn.isEmpty()) {
            Path clustersInPath = new Path(clustersIn);
            this.clusterModels = ClusterClassificationMapper.populateClusterModels(clustersInPath, conf);
            ClusteringPolicy policy = ClusterClassifier.readPolicy(ClusterClassificationMapper.finalClustersPath(clustersInPath));
            this.clusterClassifier = new ClusterClassifier(this.clusterModels, policy);
        }
        this.clusterId = new IntWritable();
    }

    @Override
    protected void map(WritableComparable<?> key, VectorWritable vw, Mapper.Context context) throws IOException, InterruptedException {
        if (!this.clusterModels.isEmpty()) {
            Vector pdfPerCluster;
            Class<?> vectorClass = vw.get().getClass();
            Vector vector = vw.get();
            if (!vectorClass.equals(NamedVector.class)) {
                if (key.getClass().equals(Text.class)) {
                    vector = new NamedVector(vector, key.toString());
                } else if (key.getClass().equals(IntWritable.class)) {
                    vector = new NamedVector(vector, Integer.toString(((IntWritable)key).get()));
                }
            }
            if (this.shouldClassify(pdfPerCluster = this.clusterClassifier.classify(vector))) {
                if (this.emitMostLikely) {
                    int maxValueIndex = pdfPerCluster.maxValueIndex();
                    this.write(new VectorWritable(vector), context, maxValueIndex, 1.0);
                } else {
                    this.writeAllAboveThreshold(new VectorWritable(vector), context, pdfPerCluster);
                }
            }
        }
    }

    private void writeAllAboveThreshold(VectorWritable vw, Mapper.Context context, Vector pdfPerCluster) throws IOException, InterruptedException {
        for (Vector.Element pdf : pdfPerCluster.nonZeroes()) {
            if (!(pdf.get() >= this.threshold)) continue;
            int clusterIndex = pdf.index();
            this.write(vw, context, clusterIndex, pdf.get());
        }
    }

    private void write(VectorWritable vw, Mapper.Context context, int clusterIndex, double weight) throws IOException, InterruptedException {
        Cluster cluster = this.clusterModels.get(clusterIndex);
        this.clusterId.set(cluster.getId());
        DistanceMeasureCluster distanceMeasureCluster = (DistanceMeasureCluster)cluster;
        DistanceMeasure distanceMeasure = distanceMeasureCluster.getMeasure();
        double distance = distanceMeasure.distance(cluster.getCenter(), vw.get());
        HashMap<Text, Text> props = Maps.newHashMap();
        props.put(new Text("distance"), new Text(Double.toString(distance)));
        context.write(this.clusterId, new WeightedPropertyVectorWritable(weight, vw.get(), props));
    }

    public static List<Cluster> populateClusterModels(Path clusterOutputPath, Configuration conf) throws IOException {
        ArrayList<Cluster> clusters = Lists.newArrayList();
        FileSystem fileSystem = clusterOutputPath.getFileSystem(conf);
        FileStatus[] clusterFiles = fileSystem.listStatus(clusterOutputPath, PathFilters.finalPartFilter());
        SequenceFileDirValueIterator it = new SequenceFileDirValueIterator(clusterFiles[0].getPath(), PathType.LIST, PathFilters.partFilter(), null, false, conf);
        while (it.hasNext()) {
            ClusterWritable next = (ClusterWritable)it.next();
            Cluster cluster = next.getValue();
            cluster.configure(conf);
            clusters.add(cluster);
        }
        return clusters;
    }

    private boolean shouldClassify(Vector pdfPerCluster) {
        return pdfPerCluster.maxValue() >= this.threshold;
    }

    private static Path finalClustersPath(Path clusterOutputPath) throws IOException {
        FileSystem fileSystem = clusterOutputPath.getFileSystem(new Configuration());
        FileStatus[] clusterFiles = fileSystem.listStatus(clusterOutputPath, PathFilters.finalPartFilter());
        return clusterFiles[0].getPath();
    }
}

