/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering;

import org.apache.mahout.clustering.GaussianAccumulator;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.function.SquareRootFunction;

public class RunningSumsGaussianAccumulator
implements GaussianAccumulator {
    private double s0;
    private Vector s1;
    private Vector s2;
    private Vector mean;
    private Vector std;

    @Override
    public double getN() {
        return this.s0;
    }

    @Override
    public Vector getMean() {
        return this.mean;
    }

    @Override
    public Vector getStd() {
        return this.std;
    }

    @Override
    public double getAverageStd() {
        if (this.s0 == 0.0) {
            return 0.0;
        }
        return this.std.zSum() / (double)this.std.size();
    }

    @Override
    public Vector getVariance() {
        return this.std.times(this.std);
    }

    @Override
    public void observe(Vector x, double weight) {
        this.s0 += weight;
        Vector weightedX = x.times(weight);
        if (this.s1 == null) {
            this.s1 = weightedX;
        } else {
            this.s1.assign(weightedX, Functions.PLUS);
        }
        Vector x2 = x.times(x).times(weight);
        if (this.s2 == null) {
            this.s2 = x2;
        } else {
            this.s2.assign(x2, Functions.PLUS);
        }
    }

    @Override
    public void compute() {
        if (this.s0 != 0.0) {
            this.mean = this.s1.divide(this.s0);
            this.std = this.s2.times(this.s0).minus(this.s1.times(this.s1)).assign(new SquareRootFunction()).divide(this.s0);
        }
    }
}

