/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.sgd;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.mahout.classifier.sgd.PriorFunction;

public class L2
implements PriorFunction {
    private static final double HALF_LOG_2PI = Math.log(Math.PI * 2) / 2.0;
    private double s2;
    private double s;

    public L2(double scale) {
        this.s = scale;
        this.s2 = scale * scale;
    }

    public L2() {
        this.s = 1.0;
        this.s2 = 1.0;
    }

    @Override
    public double age(double oldValue, double generations, double learningRate) {
        return oldValue * Math.pow(1.0 - learningRate / this.s2, generations);
    }

    @Override
    public double logP(double betaIJ) {
        return -betaIJ * betaIJ / this.s2 / 2.0 - Math.log(this.s) - HALF_LOG_2PI;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeDouble(this.s2);
        out.writeDouble(this.s);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.s2 = in.readDouble();
        this.s = in.readDouble();
    }
}

