/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.sgd;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.mahout.classifier.sgd.L1;
import org.apache.mahout.classifier.sgd.L2;
import org.apache.mahout.classifier.sgd.PriorFunction;

public class ElasticBandPrior
implements PriorFunction {
    private double alphaByLambda;
    private L1 l1;
    private L2 l2;

    public ElasticBandPrior() {
        this(0.0);
    }

    public ElasticBandPrior(double alphaByLambda) {
        this.alphaByLambda = alphaByLambda;
        this.l1 = new L1();
        this.l2 = new L2(1.0);
    }

    @Override
    public double age(double oldValue, double generations, double learningRate) {
        double newValue;
        if ((newValue = (oldValue *= Math.pow(1.0 - this.alphaByLambda * learningRate, generations)) - Math.signum(oldValue) * learningRate * generations) * oldValue < 0.0) {
            return 0.0;
        }
        return newValue;
    }

    @Override
    public double logP(double betaIJ) {
        return this.l1.logP(betaIJ) + this.alphaByLambda * this.l2.logP(betaIJ);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeDouble(this.alphaByLambda);
        this.l1.write(out);
        this.l2.write(out);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.alphaByLambda = in.readDouble();
        this.l1 = new L1();
        this.l1.readFields(in);
        this.l2 = new L2();
        this.l2.readFields(in);
    }
}

