/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.naivebayes.training;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.function.Functions;

public class WeightsMapper
extends Mapper<IntWritable, VectorWritable, Text, VectorWritable> {
    static final String NUM_LABELS = WeightsMapper.class.getName() + ".numLabels";
    private Vector weightsPerFeature;
    private Vector weightsPerLabel;

    @Override
    protected void setup(Mapper.Context ctx) throws IOException, InterruptedException {
        super.setup(ctx);
        int numLabels = Integer.parseInt(ctx.getConfiguration().get(NUM_LABELS));
        Preconditions.checkArgument(numLabels > 0, "Wrong numLabels: " + numLabels + ". Must be > 0!");
        this.weightsPerLabel = new DenseVector(numLabels);
    }

    @Override
    protected void map(IntWritable index, VectorWritable value, Mapper.Context ctx) throws IOException, InterruptedException {
        Vector instance = value.get();
        if (this.weightsPerFeature == null) {
            this.weightsPerFeature = new RandomAccessSparseVector(instance.size(), instance.getNumNondefaultElements());
        }
        int label = index.get();
        this.weightsPerFeature.assign(instance, Functions.PLUS);
        this.weightsPerLabel.set(label, this.weightsPerLabel.get(label) + instance.zSum());
    }

    @Override
    protected void cleanup(Mapper.Context ctx) throws IOException, InterruptedException {
        if (this.weightsPerFeature != null) {
            ctx.write(new Text("__SPF"), new VectorWritable(this.weightsPerFeature));
            ctx.write(new Text("__SPL"), new VectorWritable(this.weightsPerLabel));
        }
        super.cleanup(ctx);
    }
}

