/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.naivebayes.test;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.classifier.ClassifierResult;
import org.apache.mahout.classifier.ResultAnalyzer;
import org.apache.mahout.classifier.naivebayes.AbstractNaiveBayesClassifier;
import org.apache.mahout.classifier.naivebayes.BayesUtils;
import org.apache.mahout.classifier.naivebayes.ComplementaryNaiveBayesClassifier;
import org.apache.mahout.classifier.naivebayes.NaiveBayesModel;
import org.apache.mahout.classifier.naivebayes.StandardNaiveBayesClassifier;
import org.apache.mahout.classifier.naivebayes.test.BayesTestMapper;
import org.apache.mahout.common.AbstractJob;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.commandline.DefaultOptionCreator;
import org.apache.mahout.common.iterator.sequencefile.PathFilters;
import org.apache.mahout.common.iterator.sequencefile.PathType;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileDirIterable;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestNaiveBayesDriver
extends AbstractJob {
    private static final Logger log = LoggerFactory.getLogger(TestNaiveBayesDriver.class);
    public static final String COMPLEMENTARY = "class";
    private static final Pattern SLASH = Pattern.compile("/");

    public static void main(String[] args) throws Exception {
        ToolRunner.run(new Configuration(), new TestNaiveBayesDriver(), args);
    }

    @Override
    public int run(String[] args) throws Exception {
        this.addInputOption();
        this.addOutputOption();
        this.addOption(this.addOption(DefaultOptionCreator.overwriteOption().create()));
        this.addOption("model", "m", "The path to the model built during training", true);
        this.addOption(TestNaiveBayesDriver.buildOption("testComplementary", "c", "test complementary?", false, false, String.valueOf(false)));
        this.addOption(TestNaiveBayesDriver.buildOption("runSequential", "seq", "run sequential?", false, false, String.valueOf(false)));
        this.addOption("labelIndex", "l", "The path to the location of the label index", true);
        Map<String, List<String>> parsedArgs = this.parseArguments(args);
        if (parsedArgs == null) {
            return -1;
        }
        if (this.hasOption("overwrite")) {
            HadoopUtil.delete(this.getConf(), this.getOutputPath());
        }
        boolean complementary = this.hasOption("testComplementary");
        boolean sequential = this.hasOption("runSequential");
        if (sequential) {
            FileSystem fs = FileSystem.get(this.getConf());
            NaiveBayesModel model = NaiveBayesModel.materialize(new Path(this.getOption("model")), this.getConf());
            AbstractNaiveBayesClassifier classifier = complementary ? new ComplementaryNaiveBayesClassifier(model) : new StandardNaiveBayesClassifier(model);
            SequenceFile.Writer writer = new SequenceFile.Writer(fs, this.getConf(), this.getOutputPath(), Text.class, VectorWritable.class);
            SequenceFile.Reader reader = new SequenceFile.Reader(fs, this.getInputPath(), this.getConf());
            Text key = new Text();
            VectorWritable vw = new VectorWritable();
            while (reader.next(key, vw)) {
                writer.append(new Text(SLASH.split(key.toString())[1]), new VectorWritable(classifier.classifyFull(vw.get())));
            }
            writer.close();
            reader.close();
        } else {
            boolean succeeded = this.runMapReduce(parsedArgs);
            if (!succeeded) {
                return -1;
            }
        }
        Map<Integer, String> labelMap = BayesUtils.readLabelIndex(this.getConf(), new Path(this.getOption("labelIndex")));
        SequenceFileDirIterable<Text, VectorWritable> dirIterable = new SequenceFileDirIterable<Text, VectorWritable>(this.getOutputPath(), PathType.LIST, PathFilters.partFilter(), this.getConf());
        ResultAnalyzer analyzer = new ResultAnalyzer(labelMap.values(), "DEFAULT");
        TestNaiveBayesDriver.analyzeResults(labelMap, dirIterable, analyzer);
        log.info("{} Results: {}", (Object)(complementary ? "Complementary" : "Standard NB"), (Object)analyzer);
        return 0;
    }

    private boolean runMapReduce(Map<String, List<String>> parsedArgs) throws IOException, InterruptedException, ClassNotFoundException {
        Path model = new Path(this.getOption("model"));
        HadoopUtil.cacheFiles(model, this.getConf());
        Job testJob = this.prepareJob(this.getInputPath(), this.getOutputPath(), SequenceFileInputFormat.class, BayesTestMapper.class, Text.class, VectorWritable.class, SequenceFileOutputFormat.class);
        boolean complementary = this.hasOption("testComplementary");
        testJob.getConfiguration().set(COMPLEMENTARY, String.valueOf(complementary));
        return testJob.waitForCompletion(true);
    }

    private static void analyzeResults(Map<Integer, String> labelMap, SequenceFileDirIterable<Text, VectorWritable> dirIterable, ResultAnalyzer analyzer) {
        for (Pair<Text, VectorWritable> pair : dirIterable) {
            int bestIdx = Integer.MIN_VALUE;
            double bestScore = -9.223372036854776E18;
            for (Vector.Element element : pair.getSecond().get().all()) {
                if (!(element.get() > bestScore)) continue;
                bestScore = element.get();
                bestIdx = element.index();
            }
            if (bestIdx == Integer.MIN_VALUE) continue;
            ClassifierResult classifierResult = new ClassifierResult(labelMap.get(bestIdx), bestScore);
            analyzer.addInstance(pair.getFirst().toString(), classifierResult);
        }
    }
}

