/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.naivebayes.test;

import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.classifier.naivebayes.AbstractNaiveBayesClassifier;
import org.apache.mahout.classifier.naivebayes.ComplementaryNaiveBayesClassifier;
import org.apache.mahout.classifier.naivebayes.NaiveBayesModel;
import org.apache.mahout.classifier.naivebayes.StandardNaiveBayesClassifier;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public class BayesTestMapper
extends Mapper<Text, VectorWritable, Text, VectorWritable> {
    private static final Pattern SLASH = Pattern.compile("/");
    private AbstractNaiveBayesClassifier classifier;

    @Override
    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        Configuration conf = context.getConfiguration();
        Path modelPath = HadoopUtil.getSingleCachedFile(conf);
        NaiveBayesModel model = NaiveBayesModel.materialize(modelPath, conf);
        boolean compl = Boolean.parseBoolean(conf.get("class"));
        this.classifier = compl ? new ComplementaryNaiveBayesClassifier(model) : new StandardNaiveBayesClassifier(model);
    }

    @Override
    protected void map(Text key, VectorWritable value, Mapper.Context context) throws IOException, InterruptedException {
        Vector result = this.classifier.classifyFull(value.get());
        context.write(new Text(SLASH.split(key.toString())[1]), new VectorWritable(result));
    }
}

