/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.df.node;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.mahout.classifier.df.data.Instance;
import org.apache.mahout.classifier.df.node.Node;

public class Leaf
extends Node {
    private static final double EPSILON = 1.0E-6;
    private double label;

    Leaf() {
    }

    public Leaf(double label) {
        this.label = label;
    }

    @Override
    public double classify(Instance instance) {
        return this.label;
    }

    @Override
    public long maxDepth() {
        return 1L;
    }

    @Override
    public long nbNodes() {
        return 1L;
    }

    @Override
    protected Node.Type getType() {
        return Node.Type.LEAF;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Leaf)) {
            return false;
        }
        Leaf leaf = (Leaf)obj;
        return Math.abs(this.label - leaf.label) < 1.0E-6;
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.label);
        return (int)(bits ^ bits >>> 32);
    }

    @Override
    protected String getString() {
        return "";
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.label = in.readDouble();
    }

    @Override
    protected void writeNode(DataOutput out) throws IOException {
        out.writeDouble(this.label);
    }
}

