/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.df.mapreduce.inmem;

import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.classifier.df.Bagging;
import org.apache.mahout.classifier.df.data.Data;
import org.apache.mahout.classifier.df.data.DataLoader;
import org.apache.mahout.classifier.df.data.Dataset;
import org.apache.mahout.classifier.df.mapreduce.Builder;
import org.apache.mahout.classifier.df.mapreduce.MapredMapper;
import org.apache.mahout.classifier.df.mapreduce.MapredOutput;
import org.apache.mahout.classifier.df.mapreduce.inmem.InMemInputFormat;
import org.apache.mahout.classifier.df.node.Node;
import org.apache.mahout.common.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemMapper
extends MapredMapper<IntWritable, NullWritable, IntWritable, MapredOutput> {
    private static final Logger log = LoggerFactory.getLogger(InMemMapper.class);
    private Bagging bagging;
    private Random rng;

    private static Data loadData(Configuration conf, Dataset dataset) throws IOException {
        Path dataPath = Builder.getDistributedCacheFile(conf, 1);
        FileSystem fs = FileSystem.get(dataPath.toUri(), conf);
        return DataLoader.loadData(dataset, fs, dataPath);
    }

    @Override
    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        Configuration conf = context.getConfiguration();
        log.info("Loading the data...");
        Data data = InMemMapper.loadData(conf, this.getDataset());
        log.info("Data loaded : {} instances", (Object)data.size());
        this.bagging = new Bagging(this.getTreeBuilder(), data);
    }

    @Override
    protected void map(IntWritable key, NullWritable value, Mapper.Context context) throws IOException, InterruptedException {
        this.map(key, context);
    }

    void map(IntWritable key, Mapper.Context context) throws IOException, InterruptedException {
        this.initRandom((InMemInputFormat.InMemInputSplit)context.getInputSplit());
        log.debug("Building...");
        Node tree = this.bagging.build(this.rng);
        if (this.isOutput()) {
            log.debug("Outputing...");
            MapredOutput mrOut = new MapredOutput(tree);
            context.write(key, mrOut);
        }
    }

    void initRandom(InMemInputFormat.InMemInputSplit split) {
        if (this.rng == null) {
            Long seed = split.getSeed();
            log.debug("Initialising rng with seed : {}", (Object)seed);
            this.rng = seed == null ? RandomUtils.getRandom() : RandomUtils.getRandom(seed);
        }
    }
}

