/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.df.data;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Closeables;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.mahout.classifier.df.data.Instance;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;

public class Dataset {
    private Attribute[] attributes;
    private int[] ignored;
    private String[][] values;
    private int labelId;
    private int nbInstances;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    static final String TYPE = "type";
    static final String VALUES = "values";
    static final String LABEL = "label";

    protected Dataset() {
    }

    Dataset(Attribute[] attrs, List<String>[] values, int nbInstances, boolean regression) {
        Dataset.validateValues(attrs, values);
        int nbattrs = Dataset.countAttributes(attrs);
        this.attributes = new Attribute[nbattrs];
        this.values = new String[nbattrs][];
        this.ignored = new int[attrs.length - nbattrs];
        this.labelId = -1;
        int ignoredId = 0;
        int ind = 0;
        for (int attr = 0; attr < attrs.length; ++attr) {
            if (attrs[attr].isIgnored()) {
                this.ignored[ignoredId++] = attr;
                continue;
            }
            if (attrs[attr].isLabel()) {
                if (this.labelId != -1) {
                    throw new IllegalStateException("Label found more than once");
                }
                this.labelId = ind;
                attrs[attr] = regression ? Attribute.NUMERICAL : Attribute.CATEGORICAL;
            }
            if (attrs[attr].isCategorical() || !regression && attrs[attr].isLabel()) {
                this.values[ind] = new String[values[attr].size()];
                values[attr].toArray(this.values[ind]);
            }
            this.attributes[ind++] = attrs[attr];
        }
        if (this.labelId == -1) {
            throw new IllegalStateException("Label not found");
        }
        this.nbInstances = nbInstances;
    }

    public int nbValues(int attr) {
        return this.values[attr].length;
    }

    public String[] labels() {
        return Arrays.copyOf(this.values[this.labelId], this.nblabels());
    }

    public int nblabels() {
        return this.values[this.labelId].length;
    }

    public int getLabelId() {
        return this.labelId;
    }

    public double getLabel(Instance instance) {
        return instance.get(this.getLabelId());
    }

    public Attribute getAttribute(int attr) {
        return this.attributes[attr];
    }

    public int labelCode(String label) {
        return ArrayUtils.indexOf(this.values[this.labelId], label);
    }

    public String getLabelString(double code) {
        if (Double.isNaN(code)) {
            return "unknown";
        }
        return this.values[this.labelId][(int)code];
    }

    public String toString() {
        return "attributes=" + Arrays.toString((Object[])this.attributes);
    }

    public int valueOf(int attr, String token) {
        Preconditions.checkArgument(!this.isNumerical(attr), "Only for CATEGORICAL attributes");
        Preconditions.checkArgument(this.values != null, "Values not found (equals null)");
        return ArrayUtils.indexOf(this.values[attr], token);
    }

    public int[] getIgnored() {
        return this.ignored;
    }

    private static int countAttributes(Attribute[] attrs) {
        int nbattrs = 0;
        for (Attribute attr : attrs) {
            if (attr.isIgnored()) continue;
            ++nbattrs;
        }
        return nbattrs;
    }

    private static void validateValues(Attribute[] attrs, List<String>[] values) {
        Preconditions.checkArgument(attrs.length == values.length, "attrs.length != values.length");
        for (int attr = 0; attr < attrs.length; ++attr) {
            Preconditions.checkArgument(!attrs[attr].isCategorical() || values[attr] != null, "values not found for attribute " + attr);
        }
    }

    public int nbAttributes() {
        return this.attributes.length;
    }

    public boolean isNumerical(int attr) {
        return this.attributes[attr].isNumerical();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Dataset)) {
            return false;
        }
        Dataset dataset = (Dataset)obj;
        if (!Arrays.equals((Object[])this.attributes, (Object[])dataset.attributes)) {
            return false;
        }
        for (int attr = 0; attr < this.nbAttributes(); ++attr) {
            if (Arrays.equals(this.values[attr], dataset.values[attr])) continue;
            return false;
        }
        return this.labelId == dataset.labelId && this.nbInstances == dataset.nbInstances;
    }

    public int hashCode() {
        int hashCode = this.labelId + 31 * this.nbInstances;
        for (Attribute attribute : this.attributes) {
            hashCode = 31 * hashCode + attribute.hashCode();
        }
        for (Attribute attribute : this.values) {
            if (attribute == null) continue;
            for (Attribute value : attribute) {
                hashCode = 31 * hashCode + ((String)((Object)value)).hashCode();
            }
        }
        return hashCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dataset load(Configuration conf, Path path) throws IOException {
        FileSystem fs = path.getFileSystem(conf);
        long bytesToRead = fs.getFileStatus(path).getLen();
        byte[] buff = new byte[Long.valueOf(bytesToRead).intValue()];
        FSDataInputStream input = fs.open(path);
        try {
            input.readFully(buff);
        }
        finally {
            Closeables.close(input, true);
        }
        String json = new String(buff, Charset.defaultCharset());
        return Dataset.fromJSON(json);
    }

    public String toJSON() {
        LinkedList<Map<String, Object>> toWrite = Lists.newLinkedList();
        int ignoredCount = 0;
        for (int i = 0; i < this.attributes.length + this.ignored.length; ++i) {
            Map<String, Object> attribute;
            int attributesIndex = i - ignoredCount;
            if (ignoredCount < this.ignored.length && i == this.ignored[ignoredCount]) {
                attribute = this.getMap(Attribute.IGNORED, null, false);
                ++ignoredCount;
            } else {
                attribute = attributesIndex == this.labelId ? this.getMap(this.attributes[attributesIndex], this.values[attributesIndex], true) : this.getMap(this.attributes[attributesIndex], this.values[attributesIndex], false);
            }
            toWrite.add(attribute);
        }
        try {
            return OBJECT_MAPPER.writeValueAsString(toWrite);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Dataset fromJSON(String json) {
        int i;
        List fromJSON;
        try {
            fromJSON = (List)OBJECT_MAPPER.readValue(json, (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        LinkedList<Attribute> attributes = Lists.newLinkedList();
        LinkedList<Integer> ignored = Lists.newLinkedList();
        String[][] nominalValues = new String[fromJSON.size()][];
        Dataset dataset = new Dataset();
        for (i = 0; i < fromJSON.size(); ++i) {
            Map attribute = (Map)fromJSON.get(i);
            if (Attribute.fromString((String)attribute.get(TYPE)) == Attribute.IGNORED) {
                ignored.add(i);
                continue;
            }
            Attribute asAttribute = Attribute.fromString((String)attribute.get(TYPE));
            attributes.add(asAttribute);
            if (((Boolean)attribute.get(LABEL)).booleanValue()) {
                dataset.labelId = i - ignored.size();
            }
            if (attribute.get(VALUES) == null) continue;
            List get = (List)attribute.get(VALUES);
            String[] array = get.toArray(new String[get.size()]);
            nominalValues[i - ignored.size()] = array;
        }
        dataset.attributes = attributes.toArray(new Attribute[attributes.size()]);
        dataset.ignored = new int[ignored.size()];
        dataset.values = nominalValues;
        for (i = 0; i < dataset.ignored.length; ++i) {
            dataset.ignored[i] = (Integer)ignored.get(i);
        }
        return dataset;
    }

    private Map<String, Object> getMap(Attribute type, String[] values, boolean isLabel) {
        HashMap<String, Object> attribute = Maps.newHashMap();
        attribute.put(TYPE, type.toString().toLowerCase(Locale.getDefault()));
        attribute.put(VALUES, values);
        attribute.put(LABEL, isLabel);
        return attribute;
    }

    public static enum Attribute {
        IGNORED,
        NUMERICAL,
        CATEGORICAL,
        LABEL;


        public boolean isNumerical() {
            return this == NUMERICAL;
        }

        public boolean isCategorical() {
            return this == CATEGORICAL;
        }

        public boolean isLabel() {
            return this == LABEL;
        }

        public boolean isIgnored() {
            return this == IGNORED;
        }

        private static Attribute fromString(String from) {
            Attribute toReturn = LABEL;
            if (NUMERICAL.toString().equalsIgnoreCase(from)) {
                toReturn = NUMERICAL;
            } else if (CATEGORICAL.toString().equalsIgnoreCase(from)) {
                toReturn = CATEGORICAL;
            } else if (IGNORED.toString().equalsIgnoreCase(from)) {
                toReturn = IGNORED;
            }
            return toReturn;
        }
    }
}

