/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.df;

import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import org.apache.commons.cli2.CommandLine;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.OptionException;
import org.apache.commons.cli2.builder.ArgumentBuilder;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.commons.cli2.builder.GroupBuilder;
import org.apache.commons.cli2.commandline.Parser;
import org.apache.commons.cli2.option.DefaultOption;
import org.apache.commons.math3.util.FastMath;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.classifier.df.DFUtils;
import org.apache.mahout.classifier.df.DecisionForest;
import org.apache.mahout.classifier.df.ErrorEstimate;
import org.apache.mahout.classifier.df.builder.DefaultTreeBuilder;
import org.apache.mahout.classifier.df.data.Data;
import org.apache.mahout.classifier.df.data.DataLoader;
import org.apache.mahout.classifier.df.data.Dataset;
import org.apache.mahout.classifier.df.ref.SequentialBuilder;
import org.apache.mahout.common.CommandLineUtil;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.RandomWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BreimanExample
extends Configured
implements Tool {
    private static final Logger log = LoggerFactory.getLogger(BreimanExample.class);
    private double sumTestErrM;
    private double sumTestErrOne;
    private long sumTimeM;
    private long sumTimeOne;
    private long numNodesM;
    private long numNodesOne;

    private void runIteration(Random rng, Data data, int m, int nbtrees) {
        int j;
        int i;
        log.info("Splitting the data");
        Data train = data.clone();
        Data test = train.rsplit(rng, (int)((double)data.size() * 0.1));
        DefaultTreeBuilder treeBuilder = new DefaultTreeBuilder();
        SequentialBuilder forestBuilder = new SequentialBuilder(rng, treeBuilder, train);
        treeBuilder.setM(m);
        long time = System.currentTimeMillis();
        log.info("Growing a forest with m={}", (Object)m);
        DecisionForest forestM = forestBuilder.build(nbtrees);
        this.sumTimeM += System.currentTimeMillis() - time;
        this.numNodesM += forestM.nbNodes();
        treeBuilder.setM(1);
        time = System.currentTimeMillis();
        log.info("Growing a forest with m=1");
        DecisionForest forestOne = forestBuilder.build(nbtrees);
        this.sumTimeOne += System.currentTimeMillis() - time;
        this.numNodesOne += forestOne.nbNodes();
        double[] testLabels = test.extractLabels();
        double[][] predictions = new double[test.size()][];
        forestM.classify(test, predictions);
        double[] sumPredictions = new double[test.size()];
        Arrays.fill(sumPredictions, 0.0);
        for (i = 0; i < predictions.length; ++i) {
            for (j = 0; j < predictions[i].length; ++j) {
                int n = i;
                sumPredictions[n] = sumPredictions[n] + predictions[i][j];
            }
        }
        this.sumTestErrM += ErrorEstimate.errorRate(testLabels, sumPredictions);
        forestOne.classify(test, predictions);
        Arrays.fill(sumPredictions, 0.0);
        for (i = 0; i < predictions.length; ++i) {
            for (j = 0; j < predictions[i].length; ++j) {
                int n = i;
                sumPredictions[n] = sumPredictions[n] + predictions[i][j];
            }
        }
        this.sumTestErrOne += ErrorEstimate.errorRate(testLabels, sumPredictions);
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run(new Configuration(), new BreimanExample(), args);
    }

    @Override
    public int run(String[] args) throws IOException {
        Path datasetPath;
        Path dataPath;
        int nbIterations;
        int nbTrees;
        DefaultOptionBuilder obuilder = new DefaultOptionBuilder();
        ArgumentBuilder abuilder = new ArgumentBuilder();
        GroupBuilder gbuilder = new GroupBuilder();
        DefaultOption dataOpt = obuilder.withLongName("data").withShortName("d").withRequired(true).withArgument(abuilder.withName("path").withMinimum(1).withMaximum(1).create()).withDescription("Data path").create();
        DefaultOption datasetOpt = obuilder.withLongName("dataset").withShortName("ds").withRequired(true).withArgument(abuilder.withName("dataset").withMinimum(1).withMaximum(1).create()).withDescription("Dataset path").create();
        DefaultOption nbtreesOpt = obuilder.withLongName("nbtrees").withShortName("t").withRequired(true).withArgument(abuilder.withName("nbtrees").withMinimum(1).withMaximum(1).create()).withDescription("Number of trees to grow, each iteration").create();
        DefaultOption nbItersOpt = obuilder.withLongName("iterations").withShortName("i").withRequired(true).withArgument(abuilder.withName("numIterations").withMinimum(1).withMaximum(1).create()).withDescription("Number of times to repeat the test").create();
        DefaultOption helpOpt = obuilder.withLongName("help").withDescription("Print out help").withShortName("h").create();
        Group group = gbuilder.withName("Options").withOption(dataOpt).withOption(datasetOpt).withOption(nbItersOpt).withOption(nbtreesOpt).withOption(helpOpt).create();
        try {
            Parser parser = new Parser();
            parser.setGroup(group);
            CommandLine cmdLine = parser.parse(args);
            if (cmdLine.hasOption("help")) {
                CommandLineUtil.printHelp(group);
                return -1;
            }
            String dataName = cmdLine.getValue(dataOpt).toString();
            String datasetName = cmdLine.getValue(datasetOpt).toString();
            nbTrees = Integer.parseInt(cmdLine.getValue(nbtreesOpt).toString());
            nbIterations = Integer.parseInt(cmdLine.getValue(nbItersOpt).toString());
            dataPath = new Path(dataName);
            datasetPath = new Path(datasetName);
        }
        catch (OptionException e) {
            log.error("Error while parsing options", (Throwable)e);
            CommandLineUtil.printHelp(group);
            return -1;
        }
        FileSystem fs = dataPath.getFileSystem(new Configuration());
        Dataset dataset = Dataset.load(this.getConf(), datasetPath);
        Data data = DataLoader.loadData(dataset, fs, dataPath);
        int m = (int)Math.floor(FastMath.log(2.0, data.getDataset().nbAttributes()) + 1.0);
        RandomWrapper rng = RandomUtils.getRandom();
        for (int iteration = 0; iteration < nbIterations; ++iteration) {
            log.info("Iteration {}", (Object)iteration);
            this.runIteration(rng, data, m, nbTrees);
        }
        log.info("********************************************");
        log.info("Random Input Test Error : {}", (Object)(this.sumTestErrM / (double)nbIterations));
        log.info("Single Input Test Error : {}", (Object)(this.sumTestErrOne / (double)nbIterations));
        log.info("Mean Random Input Time : {}", (Object)DFUtils.elapsedTime(this.sumTimeM / (long)nbIterations));
        log.info("Mean Single Input Time : {}", (Object)DFUtils.elapsedTime(this.sumTimeOne / (long)nbIterations));
        log.info("Mean Random Input Num Nodes : {}", (Object)(this.numNodesM / (long)nbIterations));
        log.info("Mean Single Input Num Nodes : {}", (Object)(this.numNodesOne / (long)nbIterations));
        return 0;
    }
}

