/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.web;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.model.Preference;
import org.apache.mahout.cf.taste.model.PreferenceArray;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.apache.mahout.cf.taste.recommender.Recommender;
import org.apache.mahout.cf.taste.web.RecommenderSingleton;

public final class RecommenderServlet
extends HttpServlet {
    private static final int NUM_TOP_PREFERENCES = 20;
    private static final int DEFAULT_HOW_MANY = 20;
    private Recommender recommender;

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String recommenderClassName = config.getInitParameter("recommender-class");
        if (recommenderClassName == null) {
            throw new ServletException("Servlet init-param \"recommender-class\" is not defined");
        }
        RecommenderSingleton.initializeIfNeeded(recommenderClassName);
        this.recommender = RecommenderSingleton.getInstance().getRecommender();
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        block8: {
            String userIDString = request.getParameter("userID");
            if (userIDString == null) {
                throw new ServletException("userID was not specified");
            }
            long userID = Long.parseLong(userIDString);
            String howManyString = request.getParameter("howMany");
            int howMany = howManyString == null ? 20 : Integer.parseInt(howManyString);
            boolean debug = Boolean.parseBoolean(request.getParameter("debug"));
            String format = request.getParameter("format");
            if (format == null) {
                format = "text";
            }
            try {
                List<RecommendedItem> items = this.recommender.recommend(userID, howMany);
                if ("text".equals(format)) {
                    this.writePlainText(response, userID, debug, items);
                    break block8;
                }
                if ("xml".equals(format)) {
                    RecommenderServlet.writeXML(response, items);
                    break block8;
                }
                if ("json".equals(format)) {
                    RecommenderServlet.writeJSON(response, items);
                    break block8;
                }
                throw new ServletException("Bad format parameter: " + format);
            }
            catch (TasteException te) {
                throw new ServletException(te);
            }
            catch (IOException ioe) {
                throw new ServletException(ioe);
            }
        }
    }

    private static void writeXML(HttpServletResponse response, Iterable<RecommendedItem> items) throws IOException {
        response.setContentType("application/xml");
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Cache-Control", "no-cache");
        PrintWriter writer = response.getWriter();
        writer.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?><recommendedItems>");
        for (RecommendedItem recommendedItem : items) {
            writer.print("<item><value>");
            writer.print(recommendedItem.getValue());
            writer.print("</value><id>");
            writer.print(recommendedItem.getItemID());
            writer.print("</id></item>");
        }
        writer.println("</recommendedItems>");
    }

    private static void writeJSON(HttpServletResponse response, Iterable<RecommendedItem> items) throws IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Cache-Control", "no-cache");
        PrintWriter writer = response.getWriter();
        writer.print("{\"recommendedItems\":{\"item\":[");
        boolean first = true;
        for (RecommendedItem recommendedItem : items) {
            if (first) {
                first = false;
            } else {
                writer.print(',');
            }
            writer.print("{\"value\":\"");
            writer.print(recommendedItem.getValue());
            writer.print("\",\"id\":\"");
            writer.print(recommendedItem.getItemID());
            writer.print("\"}");
        }
        writer.println("]}}");
    }

    private void writePlainText(HttpServletResponse response, long userID, boolean debug, Iterable<RecommendedItem> items) throws IOException, TasteException {
        response.setContentType("text/plain");
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Cache-Control", "no-cache");
        PrintWriter writer = response.getWriter();
        if (debug) {
            this.writeDebugRecommendations(userID, items, writer);
        } else {
            RecommenderServlet.writeRecommendations(items, writer);
        }
    }

    private static void writeRecommendations(Iterable<RecommendedItem> items, PrintWriter writer) {
        for (RecommendedItem recommendedItem : items) {
            writer.print(recommendedItem.getValue());
            writer.print('\t');
            writer.println(recommendedItem.getItemID());
        }
    }

    private void writeDebugRecommendations(long userID, Iterable<RecommendedItem> items, PrintWriter writer) throws TasteException {
        DataModel dataModel = this.recommender.getDataModel();
        writer.print("User:");
        writer.println(userID);
        writer.print("Recommender: ");
        writer.println(this.recommender);
        writer.println();
        writer.print("Top ");
        writer.print(20);
        writer.println(" Preferences:");
        PreferenceArray rawPrefs = dataModel.getPreferencesFromUser(userID);
        int length = rawPrefs.length();
        PreferenceArray sortedPrefs = rawPrefs.clone();
        sortedPrefs.sortByValueReversed();
        int max = Math.min(20, length);
        for (int i = 0; i < max; ++i) {
            Preference pref = sortedPrefs.get(i);
            writer.print(pref.getValue());
            writer.print('\t');
            writer.println(pref.getItemID());
        }
        writer.println();
        writer.println("Recommendations:");
        for (RecommendedItem recommendedItem : items) {
            writer.print(recommendedItem.getValue());
            writer.print('\t');
            writer.println(recommendedItem.getItemID());
        }
    }

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        this.doGet(request, response);
    }

    public String toString() {
        return "RecommenderServlet[recommender:" + this.recommender + ']';
    }
}

