/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.recommender;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.apache.mahout.common.RandomUtils;

public final class GenericRecommendedItem
implements RecommendedItem,
Serializable {
    private final long itemID;
    private final float value;

    public GenericRecommendedItem(long itemID, float value) {
        Preconditions.checkArgument(!Float.isNaN(value), "value is NaN");
        this.itemID = itemID;
        this.value = value;
    }

    @Override
    public long getItemID() {
        return this.itemID;
    }

    @Override
    public float getValue() {
        return this.value;
    }

    public String toString() {
        return "RecommendedItem[item:" + this.itemID + ", value:" + this.value + ']';
    }

    public int hashCode() {
        return (int)this.itemID ^ RandomUtils.hashFloat(this.value);
    }

    public boolean equals(Object o) {
        if (!(o instanceof GenericRecommendedItem)) {
            return false;
        }
        RecommendedItem other = (RecommendedItem)o;
        return this.itemID == other.getItemID() && this.value == other.getValue();
    }
}

