/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.model.jdbc;

import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.model.jdbc.SQL92JDBCDataModel;
import org.apache.mahout.common.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgreSQLJDBCDataModel
extends SQL92JDBCDataModel {
    private static final Logger log = LoggerFactory.getLogger(PostgreSQLJDBCDataModel.class);
    private static final String POSTGRESQL_DUPLICATE_KEY_STATE = "23505";

    public PostgreSQLJDBCDataModel() throws TasteException {
    }

    public PostgreSQLJDBCDataModel(String dataSourceName) throws TasteException {
        super(dataSourceName);
    }

    public PostgreSQLJDBCDataModel(DataSource dataSource) {
        super(dataSource);
    }

    public PostgreSQLJDBCDataModel(DataSource dataSource, String preferenceTable, String userIDColumn, String itemIDColumn, String preferenceColumn, String timestampColumn) {
        super(dataSource, preferenceTable, userIDColumn, itemIDColumn, preferenceColumn, timestampColumn);
    }

    @Override
    public void setPreference(long userID, long itemID, float value) throws TasteException {
        Preconditions.checkArgument(!Float.isNaN(value), "NaN value");
        log.debug("Setting preference for user {}, item {}", (Object)userID, (Object)itemID);
        String setPreferenceSQL = this.getSetPreferenceSQL();
        Connection conn = null;
        PreparedStatement stmt1 = null;
        PreparedStatement stmt2 = null;
        try {
            block6: {
                conn = this.getDataSource().getConnection();
                stmt1 = conn.prepareStatement(setPreferenceSQL);
                this.setLongParameter(stmt1, 1, userID);
                this.setLongParameter(stmt1, 2, itemID);
                stmt1.setDouble(3, value);
                log.debug("Executing SQL update: {}", (Object)setPreferenceSQL);
                try {
                    stmt1.executeUpdate();
                }
                catch (SQLException sqle) {
                    if (POSTGRESQL_DUPLICATE_KEY_STATE.equals(sqle.getSQLState())) break block6;
                    throw sqle;
                }
            }
            stmt2 = conn.prepareStatement(this.getUpdatePreferenceSQL());
            stmt2.setDouble(1, value);
            this.setLongParameter(stmt2, 2, userID);
            this.setLongParameter(stmt2, 3, itemID);
            log.debug("Executing SQL update: {}", (Object)this.getUpdatePreferenceSQL());
            stmt2.executeUpdate();
        }
        catch (SQLException sqle) {
            try {
                log.warn("Exception while setting preference", (Throwable)sqle);
                throw new TasteException(sqle);
            }
            catch (Throwable throwable) {
                IOUtils.quietClose(null, stmt1, null);
                IOUtils.quietClose(null, stmt2, null);
                IOUtils.quietClose(null, null, conn);
                throw throwable;
            }
        }
        IOUtils.quietClose(null, stmt1, null);
        IOUtils.quietClose(null, stmt2, null);
        IOUtils.quietClose(null, null, conn);
    }
}

