/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.model.jdbc;

import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.model.jdbc.SQL92BooleanPrefJDBCDataModel;
import org.apache.mahout.common.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgreSQLBooleanPrefJDBCDataModel
extends SQL92BooleanPrefJDBCDataModel {
    private static final Logger log = LoggerFactory.getLogger(PostgreSQLBooleanPrefJDBCDataModel.class);
    private static final String POSTGRESQL_DUPLICATE_KEY_STATE = "23505";

    public PostgreSQLBooleanPrefJDBCDataModel() throws TasteException {
    }

    public PostgreSQLBooleanPrefJDBCDataModel(String dataSourceName) throws TasteException {
        super(dataSourceName);
    }

    public PostgreSQLBooleanPrefJDBCDataModel(DataSource dataSource) {
        super(dataSource);
    }

    public PostgreSQLBooleanPrefJDBCDataModel(DataSource dataSource, String preferenceTable, String userIDColumn, String itemIDColumn, String timestampColumn) {
        super(dataSource, preferenceTable, userIDColumn, itemIDColumn, timestampColumn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPreference(long userID, long itemID, float value) throws TasteException {
        Preconditions.checkArgument(!Float.isNaN(value), "NaN value");
        log.debug("Setting preference for user {}, item {}", (Object)userID, (Object)itemID);
        String setPreferenceSQL = this.getSetPreferenceSQL();
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.getDataSource().getConnection();
            stmt = conn.prepareStatement(setPreferenceSQL);
            this.setLongParameter(stmt, 1, userID);
            this.setLongParameter(stmt, 2, itemID);
            log.debug("Executing SQL update: {}", (Object)setPreferenceSQL);
            stmt.executeUpdate();
        }
        catch (SQLException sqle) {
            block4: {
                try {
                    if (POSTGRESQL_DUPLICATE_KEY_STATE.equals(sqle.getSQLState())) break block4;
                    log.warn("Exception while setting preference", (Throwable)sqle);
                    throw new TasteException(sqle);
                }
                catch (Throwable throwable) {
                    IOUtils.quietClose(null, stmt, conn);
                    throw throwable;
                }
            }
            IOUtils.quietClose(null, stmt, conn);
        }
        IOUtils.quietClose(null, stmt, conn);
    }
}

