/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.common;

import com.google.common.base.Preconditions;
import java.util.NoSuchElementException;
import org.apache.commons.math3.distribution.PascalDistribution;
import org.apache.mahout.cf.taste.impl.common.AbstractLongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.RandomWrapper;

public final class SamplingLongPrimitiveIterator
extends AbstractLongPrimitiveIterator {
    private final PascalDistribution geometricDistribution;
    private final LongPrimitiveIterator delegate;
    private long next;
    private boolean hasNext;

    public SamplingLongPrimitiveIterator(LongPrimitiveIterator delegate, double samplingRate) {
        this(RandomUtils.getRandom(), delegate, samplingRate);
    }

    public SamplingLongPrimitiveIterator(RandomWrapper random, LongPrimitiveIterator delegate, double samplingRate) {
        Preconditions.checkNotNull(delegate);
        Preconditions.checkArgument(samplingRate > 0.0 && samplingRate <= 1.0, "Must be: 0.0 < samplingRate <= 1.0");
        this.geometricDistribution = new PascalDistribution(random.getRandomGenerator(), 1, samplingRate);
        this.delegate = delegate;
        this.hasNext = true;
        this.doNext();
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public long nextLong() {
        if (this.hasNext) {
            long result = this.next;
            this.doNext();
            return result;
        }
        throw new NoSuchElementException();
    }

    @Override
    public long peek() {
        if (this.hasNext) {
            return this.next;
        }
        throw new NoSuchElementException();
    }

    private void doNext() {
        int toSkip = this.geometricDistribution.sample();
        this.delegate.skip(toSkip);
        if (this.delegate.hasNext()) {
            this.next = (Long)this.delegate.next();
        } else {
            this.hasNext = false;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void skip(int n) {
        int toSkip = 0;
        for (int i = 0; i < n; ++i) {
            toSkip += this.geometricDistribution.sample();
        }
        this.delegate.skip(toSkip);
        if (this.delegate.hasNext()) {
            this.next = (Long)this.delegate.next();
        } else {
            this.hasNext = false;
        }
    }

    public static LongPrimitiveIterator maybeWrapIterator(LongPrimitiveIterator delegate, double samplingRate) {
        return samplingRate >= 1.0 ? delegate : new SamplingLongPrimitiveIterator(delegate, samplingRate);
    }
}

