/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RefreshHelper
implements Refreshable {
    private static final Logger log = LoggerFactory.getLogger(RefreshHelper.class);
    private final List<Refreshable> dependencies = Lists.newArrayListWithCapacity(3);
    private final ReentrantLock refreshLock = new ReentrantLock();
    private final Callable<?> refreshRunnable;

    public RefreshHelper(Callable<?> refreshRunnable) {
        this.refreshRunnable = refreshRunnable;
    }

    public void addDependency(Refreshable refreshable) {
        if (refreshable != null) {
            this.dependencies.add(refreshable);
        }
    }

    public void removeDependency(Refreshable refreshable) {
        if (refreshable != null) {
            this.dependencies.remove(refreshable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh(Collection<Refreshable> alreadyRefreshed) {
        if (this.refreshLock.tryLock()) {
            try {
                alreadyRefreshed = RefreshHelper.buildRefreshed(alreadyRefreshed);
                for (Refreshable dependency : this.dependencies) {
                    RefreshHelper.maybeRefresh(alreadyRefreshed, dependency);
                }
                if (this.refreshRunnable != null) {
                    try {
                        this.refreshRunnable.call();
                    }
                    catch (Exception e) {
                        log.warn("Unexpected exception while refreshing", (Throwable)e);
                    }
                }
            }
            finally {
                this.refreshLock.unlock();
            }
        }
    }

    public static Collection<Refreshable> buildRefreshed(Collection<Refreshable> currentAlreadyRefreshed) {
        return currentAlreadyRefreshed == null ? Sets.newHashSetWithExpectedSize(3) : currentAlreadyRefreshed;
    }

    public static void maybeRefresh(Collection<Refreshable> alreadyRefreshed, Refreshable refreshable) {
        if (!alreadyRefreshed.contains(refreshable)) {
            alreadyRefreshed.add(refreshable);
            log.info("Added refreshable: {}", (Object)refreshable);
            refreshable.refresh(alreadyRefreshed);
            log.info("Refreshed: {}", alreadyRefreshed);
        }
    }
}

