/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop.item;

import java.io.IOException;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.mahout.math.VarIntWritable;
import org.apache.mahout.math.VarLongWritable;

public final class ItemIDIndexReducer
extends Reducer<VarIntWritable, VarLongWritable, VarIntWritable, VarLongWritable> {
    private final VarLongWritable minimumItemIDWritable = new VarLongWritable();

    @Override
    protected void reduce(VarIntWritable index, Iterable<VarLongWritable> possibleItemIDs, Reducer.Context context) throws IOException, InterruptedException {
        long minimumItemID = Long.MAX_VALUE;
        for (VarLongWritable varLongWritable : possibleItemIDs) {
            long itemID = varLongWritable.get();
            if (itemID >= minimumItemID) continue;
            minimumItemID = itemID;
        }
        if (minimumItemID != Long.MAX_VALUE) {
            this.minimumItemIDWritable.set(minimumItemID);
            context.write(index, this.minimumItemIDWritable);
        }
    }
}

