/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop.als;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.common.AbstractJob;
import org.apache.mahout.common.RandomUtils;

public class DatasetSplitter
extends AbstractJob {
    private static final String TRAINING_PERCENTAGE = DatasetSplitter.class.getName() + ".trainingPercentage";
    private static final String PROBE_PERCENTAGE = DatasetSplitter.class.getName() + ".probePercentage";
    private static final String PART_TO_USE = DatasetSplitter.class.getName() + ".partToUse";
    private static final Text INTO_TRAINING_SET = new Text("T");
    private static final Text INTO_PROBE_SET = new Text("P");
    private static final double DEFAULT_TRAINING_PERCENTAGE = 0.9;
    private static final double DEFAULT_PROBE_PERCENTAGE = 0.1;

    public static void main(String[] args) throws Exception {
        ToolRunner.run(new DatasetSplitter(), args);
    }

    @Override
    public int run(String[] args) throws Exception {
        this.addInputOption();
        this.addOutputOption();
        this.addOption("trainingPercentage", "t", "percentage of the data to use as training set (default: 0.9)", String.valueOf(0.9));
        this.addOption("probePercentage", "p", "percentage of the data to use as probe set (default: 0.1)", String.valueOf(0.1));
        Map<String, List<String>> parsedArgs = this.parseArguments(args);
        if (parsedArgs == null) {
            return -1;
        }
        double trainingPercentage = Double.parseDouble(this.getOption("trainingPercentage"));
        double probePercentage = Double.parseDouble(this.getOption("probePercentage"));
        String tempDir = this.getOption("tempDir");
        Path markedPrefs = new Path(tempDir, "markedPreferences");
        Path trainingSetPath = new Path(this.getOutputPath(), "trainingSet");
        Path probeSetPath = new Path(this.getOutputPath(), "probeSet");
        Job markPreferences = this.prepareJob(this.getInputPath(), markedPrefs, TextInputFormat.class, MarkPreferencesMapper.class, Text.class, Text.class, SequenceFileOutputFormat.class);
        markPreferences.getConfiguration().set(TRAINING_PERCENTAGE, String.valueOf(trainingPercentage));
        markPreferences.getConfiguration().set(PROBE_PERCENTAGE, String.valueOf(probePercentage));
        boolean succeeded = markPreferences.waitForCompletion(true);
        if (!succeeded) {
            return -1;
        }
        Job createTrainingSet = this.prepareJob(markedPrefs, trainingSetPath, SequenceFileInputFormat.class, WritePrefsMapper.class, NullWritable.class, Text.class, TextOutputFormat.class);
        createTrainingSet.getConfiguration().set(PART_TO_USE, INTO_TRAINING_SET.toString());
        succeeded = createTrainingSet.waitForCompletion(true);
        if (!succeeded) {
            return -1;
        }
        Job createProbeSet = this.prepareJob(markedPrefs, probeSetPath, SequenceFileInputFormat.class, WritePrefsMapper.class, NullWritable.class, Text.class, TextOutputFormat.class);
        createProbeSet.getConfiguration().set(PART_TO_USE, INTO_PROBE_SET.toString());
        succeeded = createProbeSet.waitForCompletion(true);
        if (!succeeded) {
            return -1;
        }
        return 0;
    }

    static class WritePrefsMapper
    extends Mapper<Text, Text, NullWritable, Text> {
        private String partToUse;

        WritePrefsMapper() {
        }

        @Override
        protected void setup(Mapper.Context ctx) throws IOException, InterruptedException {
            this.partToUse = ctx.getConfiguration().get(PART_TO_USE);
        }

        @Override
        protected void map(Text key, Text text, Mapper.Context ctx) throws IOException, InterruptedException {
            if (this.partToUse.equals(key.toString())) {
                ctx.write(NullWritable.get(), text);
            }
        }
    }

    static class MarkPreferencesMapper
    extends Mapper<LongWritable, Text, Text, Text> {
        private Random random;
        private double trainingBound;
        private double probeBound;

        MarkPreferencesMapper() {
        }

        @Override
        protected void setup(Mapper.Context ctx) throws IOException, InterruptedException {
            this.random = RandomUtils.getRandom();
            this.trainingBound = Double.parseDouble(ctx.getConfiguration().get(TRAINING_PERCENTAGE));
            this.probeBound = this.trainingBound + Double.parseDouble(ctx.getConfiguration().get(PROBE_PERCENTAGE));
        }

        @Override
        protected void map(LongWritable key, Text text, Mapper.Context ctx) throws IOException, InterruptedException {
            double randomValue = this.random.nextDouble();
            if (randomValue <= this.trainingBound) {
                ctx.write(INTO_TRAINING_SET, text);
            } else if (randomValue <= this.probeBound) {
                ctx.write(INTO_PROBE_SET, text);
            }
        }
    }
}

