/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop;

import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.cf.taste.hadoop.EntityPrefWritable;
import org.apache.mahout.math.VarLongWritable;

public abstract class ToEntityPrefsMapper
extends Mapper<LongWritable, Text, VarLongWritable, VarLongWritable> {
    public static final String TRANSPOSE_USER_ITEM = ToEntityPrefsMapper.class + "transposeUserItem";
    public static final String RATING_SHIFT = ToEntityPrefsMapper.class + "shiftRatings";
    private static final Pattern DELIMITER = Pattern.compile("[\t,]");
    private boolean booleanData;
    private boolean transpose;
    private final boolean itemKey;
    private float ratingShift;

    ToEntityPrefsMapper(boolean itemKey) {
        this.itemKey = itemKey;
    }

    @Override
    protected void setup(Mapper.Context context) {
        Configuration jobConf = context.getConfiguration();
        this.booleanData = jobConf.getBoolean("booleanData", false);
        this.transpose = jobConf.getBoolean(TRANSPOSE_USER_ITEM, false);
        this.ratingShift = Float.parseFloat(jobConf.get(RATING_SHIFT, "0.0"));
    }

    @Override
    public void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        String[] tokens = DELIMITER.split(value.toString());
        long userID = Long.parseLong(tokens[0]);
        long itemID = Long.parseLong(tokens[1]);
        if (this.itemKey ^ this.transpose) {
            long temp = userID;
            userID = itemID;
            itemID = temp;
        }
        if (this.booleanData) {
            context.write(new VarLongWritable(userID), new VarLongWritable(itemID));
        } else {
            float prefValue = tokens.length > 2 ? Float.parseFloat(tokens[2]) + this.ratingShift : 1.0f;
            context.write(new VarLongWritable(userID), new EntityPrefWritable(itemID, prefValue));
        }
    }
}

