/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.example.kddcup.track2;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.example.kddcup.KDDCupDataModel;
import org.apache.mahout.cf.taste.example.kddcup.track2.TrackData;
import org.apache.mahout.cf.taste.impl.common.FastByIDMap;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.cf.taste.similarity.ItemSimilarity;
import org.apache.mahout.common.iterator.FileLineIterable;

final class TrackItemSimilarity
implements ItemSimilarity {
    private final FastByIDMap<TrackData> trackData = new FastByIDMap();

    TrackItemSimilarity(File dataFileDirectory) throws IOException {
        for (String line : new FileLineIterable(KDDCupDataModel.getTrackFile(dataFileDirectory))) {
            TrackData trackDatum = new TrackData(line);
            this.trackData.put(trackDatum.getTrackID(), trackDatum);
        }
    }

    @Override
    public double itemSimilarity(long itemID1, long itemID2) {
        if (itemID1 == itemID2) {
            return 1.0;
        }
        TrackData data1 = this.trackData.get(itemID1);
        TrackData data2 = this.trackData.get(itemID2);
        if (data1 == null || data2 == null) {
            return 0.0;
        }
        if (data1.getAlbumID() != Long.MIN_VALUE && data1.getAlbumID() == data2.getAlbumID()) {
            return 0.9;
        }
        if (data1.getArtistID() != Long.MIN_VALUE && data1.getArtistID() == data2.getArtistID()) {
            return 0.7;
        }
        FastIDSet genres1 = data1.getGenreIDs();
        FastIDSet genres2 = data2.getGenreIDs();
        if (genres1 == null || genres2 == null) {
            return 0.0;
        }
        int intersectionSize = genres1.intersectionSize(genres2);
        if (intersectionSize == 0) {
            return 0.0;
        }
        int unionSize = genres1.size() + genres2.size() - intersectionSize;
        return (double)intersectionSize / (4.0 * (double)unionSize);
    }

    @Override
    public double[] itemSimilarities(long itemID1, long[] itemID2s) {
        int length = itemID2s.length;
        double[] result = new double[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.itemSimilarity(itemID1, itemID2s[i]);
        }
        return result;
    }

    @Override
    public long[] allSimilarItemIDs(long itemID) {
        FastIDSet allSimilarItemIDs = new FastIDSet();
        LongPrimitiveIterator allItemIDs = this.trackData.keySetIterator();
        while (allItemIDs.hasNext()) {
            long possiblySimilarItemID = allItemIDs.nextLong();
            if (Double.isNaN(this.itemSimilarity(itemID, possiblySimilarItemID))) continue;
            allSimilarItemIDs.add(possiblySimilarItemID);
        }
        return allSimilarItemIDs.toArray();
    }

    @Override
    public void refresh(Collection<Refreshable> alreadyRefreshed) {
    }
}

