/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.example.kddcup.track2;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.example.kddcup.track2.TrackItemSimilarity;
import org.apache.mahout.cf.taste.impl.similarity.AbstractItemSimilarity;
import org.apache.mahout.cf.taste.impl.similarity.LogLikelihoodSimilarity;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.similarity.ItemSimilarity;

final class HybridSimilarity
extends AbstractItemSimilarity {
    private final ItemSimilarity cfSimilarity;
    private final ItemSimilarity contentSimilarity;

    HybridSimilarity(DataModel dataModel, File dataFileDirectory) throws IOException {
        super(dataModel);
        this.cfSimilarity = new LogLikelihoodSimilarity(dataModel);
        this.contentSimilarity = new TrackItemSimilarity(dataFileDirectory);
    }

    @Override
    public double itemSimilarity(long itemID1, long itemID2) throws TasteException {
        return this.contentSimilarity.itemSimilarity(itemID1, itemID2) * this.cfSimilarity.itemSimilarity(itemID1, itemID2);
    }

    @Override
    public double[] itemSimilarities(long itemID1, long[] itemID2s) throws TasteException {
        double[] result = this.contentSimilarity.itemSimilarities(itemID1, itemID2s);
        double[] multipliers = this.cfSimilarity.itemSimilarities(itemID1, itemID2s);
        for (int i = 0; i < result.length; ++i) {
            int n = i;
            result[n] = result[n] * multipliers[i];
        }
        return result;
    }

    @Override
    public void refresh(Collection<Refreshable> alreadyRefreshed) {
        this.cfSimilarity.refresh(alreadyRefreshed);
    }
}

