/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.example.kddcup.track1;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.eval.DataModelBuilder;
import org.apache.mahout.cf.taste.eval.RecommenderBuilder;
import org.apache.mahout.cf.taste.example.kddcup.DataFileIterable;
import org.apache.mahout.cf.taste.example.kddcup.KDDCupDataModel;
import org.apache.mahout.cf.taste.impl.common.FullRunningAverage;
import org.apache.mahout.cf.taste.impl.common.FullRunningAverageAndStdDev;
import org.apache.mahout.cf.taste.impl.common.RunningAverage;
import org.apache.mahout.cf.taste.impl.eval.AbstractDifferenceRecommenderEvaluator;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.model.Preference;
import org.apache.mahout.cf.taste.model.PreferenceArray;
import org.apache.mahout.cf.taste.recommender.Recommender;
import org.apache.mahout.common.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Track1RecommenderEvaluator
extends AbstractDifferenceRecommenderEvaluator {
    private static final Logger log = LoggerFactory.getLogger(Track1RecommenderEvaluator.class);
    private RunningAverage average;
    private final File dataFileDirectory;

    public Track1RecommenderEvaluator(File dataFileDirectory) {
        this.setMaxPreference(100.0f);
        this.setMinPreference(0.0f);
        this.average = new FullRunningAverage();
        this.dataFileDirectory = dataFileDirectory;
    }

    @Override
    public double evaluate(RecommenderBuilder recommenderBuilder, DataModelBuilder dataModelBuilder, DataModel dataModel, double trainingPercentage, double evaluationPercentage) throws TasteException {
        Recommender recommender = recommenderBuilder.buildRecommender(dataModel);
        ArrayList<Callable<Void>> estimateCallables = Lists.newArrayList();
        AtomicInteger noEstimateCounter = new AtomicInteger();
        for (Pair<PreferenceArray, long[]> userData : new DataFileIterable(KDDCupDataModel.getValidationFile(this.dataFileDirectory))) {
            PreferenceArray validationPrefs = userData.getFirst();
            long userID = validationPrefs.get(0).getUserID();
            estimateCallables.add(new AbstractDifferenceRecommenderEvaluator.PreferenceEstimateCallable(recommender, userID, validationPrefs, noEstimateCounter));
        }
        FullRunningAverageAndStdDev timing = new FullRunningAverageAndStdDev();
        Track1RecommenderEvaluator.execute(estimateCallables, noEstimateCounter, timing);
        double result = this.computeFinalEvaluation();
        log.info("Evaluation result: {}", (Object)result);
        return result;
    }

    @Override
    protected void reset() {
        this.average = new FullRunningAverage();
    }

    @Override
    protected void processOneEstimate(float estimatedPreference, Preference realPref) {
        double diff = realPref.getValue() - estimatedPreference;
        this.average.addDatum(diff * diff);
    }

    @Override
    protected double computeFinalEvaluation() {
        return Math.sqrt(this.average.getAverage());
    }
}

