/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.example.email;

import java.io.IOException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.cf.taste.example.email.EmailUtility;
import org.apache.mahout.math.VarIntWritable;

public final class MsgIdToDictionaryMapper
extends Mapper<Text, Text, Text, VarIntWritable> {
    @Override
    protected void map(Text key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        String keyStr = key.toString();
        int idx = keyStr.lastIndexOf(64);
        if (idx == -1) {
            context.getCounter(EmailUtility.Counters.NO_MESSAGE_ID).increment(1L);
        } else {
            String msgId = keyStr.substring((idx = keyStr.lastIndexOf(47, idx)) + 1);
            if (EmailUtility.WHITESPACE.matcher(msgId).matches()) {
                context.getCounter(EmailUtility.Counters.NO_MESSAGE_ID).increment(1L);
            } else {
                context.write(new Text(msgId), new VarIntWritable(1));
            }
        }
    }
}

