/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.example.email;

import java.io.IOException;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;

public class MailToRecReducer
extends Reducer<Text, LongWritable, Text, NullWritable> {
    private boolean useCounts = true;
    public static final String USE_COUNTS_PREFERENCE = "useBooleanPreferences";

    @Override
    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        this.useCounts = context.getConfiguration().getBoolean(USE_COUNTS_PREFERENCE, true);
    }

    @Override
    protected void reduce(Text key, Iterable<LongWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        if (this.useCounts) {
            long sum = 0L;
            for (LongWritable value : values) {
                ++sum;
            }
            context.write(new Text(key.toString() + ',' + sum), null);
        } else {
            context.write(new Text(key.toString()), null);
        }
    }
}

