/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.example.email;

import java.io.IOException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.cf.taste.example.email.EmailUtility;
import org.apache.mahout.math.VarIntWritable;

public final class FromEmailToDictionaryMapper
extends Mapper<Text, Text, Text, VarIntWritable> {
    private String separator;

    @Override
    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.separator = context.getConfiguration().get("separator");
    }

    @Override
    protected void map(Text key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        String valStr = value.toString();
        int idx = valStr.indexOf(this.separator);
        if (idx == -1) {
            context.getCounter(EmailUtility.Counters.NO_FROM_ADDRESS).increment(1L);
        } else {
            String full = valStr.substring(0, idx);
            if (EmailUtility.WHITESPACE.matcher(full = EmailUtility.cleanUpEmailAddress(full)).matches()) {
                context.getCounter(EmailUtility.Counters.NO_FROM_ADDRESS).increment(1L);
            } else {
                context.write(new Text(full), new VarIntWritable(1));
            }
        }
    }
}

