/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.old;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.facet.old.ScoredDocIDs;
import org.apache.lucene.facet.old.ScoredDocIDsIterator;
import org.apache.lucene.facet.search.FacetsCollector;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;

public class MatchingDocsAsScoredDocIDs
implements ScoredDocIDs {
    final List<FacetsCollector.MatchingDocs> matchingDocs;
    final int size;

    public MatchingDocsAsScoredDocIDs(List<FacetsCollector.MatchingDocs> matchingDocs) {
        this.matchingDocs = matchingDocs;
        int totalSize = 0;
        for (FacetsCollector.MatchingDocs md : matchingDocs) {
            totalSize += md.totalHits;
        }
        this.size = totalSize;
    }

    @Override
    public ScoredDocIDsIterator iterator() throws IOException {
        return new ScoredDocIDsIterator(){
            final Iterator<FacetsCollector.MatchingDocs> mdIter;
            int scoresIdx;
            int doc;
            FacetsCollector.MatchingDocs current;
            int currentLength;
            boolean done;
            {
                this.mdIter = MatchingDocsAsScoredDocIDs.this.matchingDocs.iterator();
                this.scoresIdx = 0;
                this.doc = 0;
                this.done = false;
            }

            @Override
            public boolean next() {
                if (this.done) {
                    return false;
                }
                while (this.current == null) {
                    if (!this.mdIter.hasNext()) {
                        this.done = true;
                        return false;
                    }
                    this.current = this.mdIter.next();
                    this.currentLength = this.current.bits.length();
                    this.doc = 0;
                    this.scoresIdx = 0;
                    if (this.doc >= this.currentLength || (this.doc = this.current.bits.nextSetBit(this.doc)) == -1) {
                        this.current = null;
                        continue;
                    }
                    this.doc = -1;
                }
                ++this.doc;
                if (this.doc >= this.currentLength || (this.doc = this.current.bits.nextSetBit(this.doc)) == -1) {
                    this.current = null;
                    return this.next();
                }
                return true;
            }

            @Override
            public float getScore() {
                return this.current.scores == null ? 1.0f : this.current.scores[this.scoresIdx++];
            }

            @Override
            public int getDocID() {
                return this.done ? Integer.MAX_VALUE : this.doc + this.current.context.docBase;
            }
        };
    }

    @Override
    public DocIdSet getDocIDs() {
        return new DocIdSet(){
            final Iterator<FacetsCollector.MatchingDocs> mdIter;
            int doc;
            FacetsCollector.MatchingDocs current;
            int currentLength;
            boolean done;
            {
                this.mdIter = MatchingDocsAsScoredDocIDs.this.matchingDocs.iterator();
                this.doc = 0;
                this.done = false;
            }

            @Override
            public DocIdSetIterator iterator() throws IOException {
                return new DocIdSetIterator(){

                    @Override
                    public int nextDoc() throws IOException {
                        if (done) {
                            return Integer.MAX_VALUE;
                        }
                        while (current == null) {
                            if (!mdIter.hasNext()) {
                                done = true;
                                return Integer.MAX_VALUE;
                            }
                            current = mdIter.next();
                            currentLength = current.bits.length();
                            doc = 0;
                            if (doc >= currentLength || (doc = current.bits.nextSetBit(doc)) == -1) {
                                current = null;
                                continue;
                            }
                            doc = -1;
                        }
                        ++doc;
                        if (doc >= currentLength || (doc = current.bits.nextSetBit(doc)) == -1) {
                            current = null;
                            return this.nextDoc();
                        }
                        return doc + current.context.docBase;
                    }

                    @Override
                    public int docID() {
                        return doc + current.context.docBase;
                    }

                    @Override
                    public long cost() {
                        return MatchingDocsAsScoredDocIDs.this.size;
                    }

                    @Override
                    public int advance(int target) throws IOException {
                        throw new UnsupportedOperationException("not supported");
                    }
                };
            }
        };
    }

    @Override
    public int size() {
        return this.size;
    }
}

