/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import java.util.Locale;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.feeds.DocMaker;
import org.apache.lucene.benchmark.byTask.tasks.PerfTask;
import org.apache.lucene.document.Document;

public class AddDocTask
extends PerfTask {
    private int docSize = 0;
    protected Document doc = null;

    public AddDocTask(PerfRunData runData) {
        super(runData);
    }

    @Override
    public void setup() throws Exception {
        super.setup();
        DocMaker docMaker = this.getRunData().getDocMaker();
        this.doc = this.docSize > 0 ? docMaker.makeDocument(this.docSize) : docMaker.makeDocument();
    }

    @Override
    public void tearDown() throws Exception {
        this.doc = null;
        super.tearDown();
    }

    @Override
    protected String getLogMessage(int recsCount) {
        return String.format(Locale.ROOT, "added %9d docs", recsCount);
    }

    @Override
    public int doLogic() throws Exception {
        this.getRunData().getIndexWriter().addDocument(this.doc);
        return 1;
    }

    @Override
    public void setParams(String params) {
        super.setParams(params);
        this.docSize = (int)Float.parseFloat(params);
    }

    @Override
    public boolean supportsParams() {
        return true;
    }
}

