/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.servlet;

import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.internal.UniqueAnnotations;
import com.google.inject.internal.util.$Lists;
import com.google.inject.servlet.FilterDefinition;
import com.google.inject.servlet.ServletModule;
import com.google.inject.servlet.UriPatternType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FiltersModuleBuilder
extends AbstractModule {
    private final List<FilterDefinition> filterDefinitions = $Lists.newArrayList();
    private final List<FilterInstanceBindingEntry> filterInstanceEntries = $Lists.newArrayList();

    FiltersModuleBuilder() {
    }

    @Override
    protected void configure() {
        for (FilterInstanceBindingEntry entry : this.filterInstanceEntries) {
            this.bind(entry.key).toInstance(entry.filter);
        }
        for (FilterDefinition fd : this.filterDefinitions) {
            this.bind(FilterDefinition.class).annotatedWith(UniqueAnnotations.create()).toProvider(fd);
        }
    }

    public ServletModule.FilterKeyBindingBuilder filter(List<String> patterns) {
        return new FilterKeyBindingBuilderImpl(patterns, UriPatternType.SERVLET);
    }

    public ServletModule.FilterKeyBindingBuilder filterRegex(List<String> regexes) {
        return new FilterKeyBindingBuilderImpl(regexes, UriPatternType.REGEX);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FilterKeyBindingBuilderImpl
    implements ServletModule.FilterKeyBindingBuilder {
        private final List<String> uriPatterns;
        private final UriPatternType uriPatternType;

        private FilterKeyBindingBuilderImpl(List<String> uriPatterns, UriPatternType uriPatternType) {
            this.uriPatterns = uriPatterns;
            this.uriPatternType = uriPatternType;
        }

        @Override
        public void through(Class<? extends Filter> filterKey) {
            this.through(Key.get(filterKey));
        }

        @Override
        public void through(Key<? extends Filter> filterKey) {
            this.through(filterKey, new HashMap<String, String>());
        }

        @Override
        public void through(Filter filter) {
            this.through(filter, new HashMap<String, String>());
        }

        @Override
        public void through(Class<? extends Filter> filterKey, Map<String, String> initParams) {
            this.through(Key.get(filterKey), initParams);
        }

        @Override
        public void through(Key<? extends Filter> filterKey, Map<String, String> initParams) {
            this.through(filterKey, initParams, null);
        }

        private void through(Key<? extends Filter> filterKey, Map<String, String> initParams, Filter filterInstance) {
            for (String pattern : this.uriPatterns) {
                FiltersModuleBuilder.this.filterDefinitions.add(new FilterDefinition(pattern, filterKey, UriPatternType.get(this.uriPatternType, pattern), initParams, filterInstance));
            }
        }

        @Override
        public void through(Filter filter, Map<String, String> initParams) {
            Key<Filter> filterKey = Key.get(Filter.class, UniqueAnnotations.create());
            FiltersModuleBuilder.this.filterInstanceEntries.add(new FilterInstanceBindingEntry(filterKey, filter));
            this.through(filterKey, initParams, filter);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FilterInstanceBindingEntry {
        final Key<Filter> key;
        final Filter filter;

        FilterInstanceBindingEntry(Key<Filter> key, Filter filter) {
            this.key = key;
            this.filter = filter;
        }
    }
}

