/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.syntheticcontrol.dirichlet;

import java.util.Map;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.builder.ArgumentBuilder;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.clustering.conversion.InputDriver;
import org.apache.mahout.clustering.dirichlet.DirichletDriver;
import org.apache.mahout.clustering.dirichlet.models.DistributionDescription;
import org.apache.mahout.clustering.dirichlet.models.GaussianClusterDistribution;
import org.apache.mahout.common.AbstractJob;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.commandline.DefaultOptionCreator;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.utils.clustering.ClusterDumper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Job
extends AbstractJob {
    private static final Logger log = LoggerFactory.getLogger(Job.class);
    private static final String DIRECTORY_CONTAINING_CONVERTED_INPUT = "data";

    private Job() {
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0) {
            log.info("Running with only user-supplied arguments");
            ToolRunner.run((Configuration)new Configuration(), (Tool)new Job(), (String[])args);
        } else {
            log.info("Running with default arguments");
            Path output = new Path("output");
            HadoopUtil.delete((Configuration)new Configuration(), (Path[])new Path[]{output});
            DistributionDescription description = new DistributionDescription(GaussianClusterDistribution.class.getName(), RandomAccessSparseVector.class.getName(), null, 60);
            Job.run(new Path("testdata"), output, description, 10, 5, 1.0, true, 0.0);
        }
    }

    public int run(String[] args) throws Exception {
        this.addInputOption();
        this.addOutputOption();
        this.addOption((Option)DefaultOptionCreator.maxIterationsOption().create());
        this.addOption((Option)DefaultOptionCreator.numClustersOption().withRequired(true).create());
        this.addOption((Option)DefaultOptionCreator.overwriteOption().create());
        this.addOption((Option)new DefaultOptionBuilder().withLongName("alpha").withRequired(false).withShortName("m").withArgument(new ArgumentBuilder().withName("alpha").withDefault((Object)"1.0").withMinimum(1).withMaximum(1).create()).withDescription("The alpha0 value for the DirichletDistribution. Defaults to 1.0").create());
        this.addOption((Option)new DefaultOptionBuilder().withLongName("modelDist").withRequired(false).withShortName("md").withArgument(new ArgumentBuilder().withName("modelDist").withDefault((Object)GaussianClusterDistribution.class.getName()).withMinimum(1).withMaximum(1).create()).withDescription("The ModelDistribution class name. Defaults to GaussianClusterDistribution").create());
        this.addOption((Option)new DefaultOptionBuilder().withLongName("modelPrototype").withRequired(false).withShortName("mp").withArgument(new ArgumentBuilder().withName("prototypeClass").withDefault((Object)RandomAccessSparseVector.class.getName()).withMinimum(1).withMaximum(1).create()).withDescription("The ModelDistribution prototype Vector class name. Defaults to RandomAccessSparseVector").create());
        this.addOption((Option)DefaultOptionCreator.distanceMeasureOption().withRequired(false).create());
        this.addOption((Option)DefaultOptionCreator.emitMostLikelyOption().create());
        this.addOption((Option)DefaultOptionCreator.thresholdOption().create());
        Map argMap = this.parseArguments(args);
        if (argMap == null) {
            return -1;
        }
        Path input = this.getInputPath();
        Path output = this.getOutputPath();
        if (this.hasOption("overwrite")) {
            HadoopUtil.delete((Configuration)this.getConf(), (Path[])new Path[]{output});
        }
        String modelFactory = this.getOption("modelDist");
        String modelPrototype = this.getOption("modelPrototype");
        String distanceMeasure = this.getOption("distanceMeasure");
        int numModels = Integer.parseInt(this.getOption("numClusters"));
        int maxIterations = Integer.parseInt(this.getOption("maxIter"));
        boolean emitMostLikely = Boolean.parseBoolean(this.getOption("emitMostLikely"));
        double threshold = Double.parseDouble(this.getOption("threshold"));
        double alpha0 = Double.parseDouble(this.getOption("alpha"));
        DistributionDescription description = new DistributionDescription(modelFactory, modelPrototype, distanceMeasure, 60);
        Job.run(input, output, description, numModels, maxIterations, alpha0, emitMostLikely, threshold);
        return 0;
    }

    public static void run(Path input, Path output, DistributionDescription description, int numModels, int maxIterations, double alpha0, boolean emitMostLikely, double threshold) throws Exception {
        Path directoryContainingConvertedInput = new Path(output, DIRECTORY_CONTAINING_CONVERTED_INPUT);
        InputDriver.runJob((Path)input, (Path)directoryContainingConvertedInput, (String)"org.apache.mahout.math.RandomAccessSparseVector");
        DirichletDriver.run((Configuration)new Configuration(), (Path)directoryContainingConvertedInput, (Path)output, (DistributionDescription)description, (int)numModels, (int)maxIterations, (double)alpha0, (boolean)true, (boolean)emitMostLikely, (double)threshold, (boolean)false);
        ClusterDumper clusterDumper = new ClusterDumper(new Path(output, "clusters-*-final"), new Path(output, "clusteredPoints"));
        clusterDumper.printClusters(null);
    }
}

