/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.display;

import com.google.common.collect.Lists;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.mahout.clustering.classify.ClusterClassifier;
import org.apache.mahout.clustering.display.DisplayClustering;
import org.apache.mahout.clustering.iterator.ClusterIterator;
import org.apache.mahout.clustering.iterator.ClusteringPolicy;
import org.apache.mahout.clustering.iterator.KMeansClusteringPolicy;
import org.apache.mahout.clustering.kmeans.KMeansDriver;
import org.apache.mahout.clustering.kmeans.Kluster;
import org.apache.mahout.clustering.kmeans.RandomSeedGenerator;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.common.distance.ManhattanDistanceMeasure;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public class DisplayKMeans
extends DisplayClustering {
    DisplayKMeans() {
        this.initialize();
        this.setTitle("k-Means Clusters (>" + (int)(significance * 100.0) + "% of population)");
    }

    public static void main(String[] args) throws Exception {
        ManhattanDistanceMeasure measure = new ManhattanDistanceMeasure();
        Path samples = new Path("samples");
        Path output = new Path("output");
        Configuration conf = new Configuration();
        HadoopUtil.delete((Configuration)conf, (Path[])new Path[]{samples});
        HadoopUtil.delete((Configuration)conf, (Path[])new Path[]{output});
        RandomUtils.useTestSeed();
        DisplayKMeans.generateSamples();
        DisplayKMeans.writeSampleData(samples);
        boolean runClusterer = true;
        double convergenceDelta = 0.001;
        int numClusters = 3;
        int maxIterations = 10;
        if (runClusterer) {
            DisplayKMeans.runSequentialKMeansClusterer(conf, samples, output, (DistanceMeasure)measure, numClusters, maxIterations, convergenceDelta);
        } else {
            DisplayKMeans.runSequentialKMeansClassifier(conf, samples, output, (DistanceMeasure)measure, numClusters, maxIterations, convergenceDelta);
        }
        new DisplayKMeans();
    }

    private static void runSequentialKMeansClassifier(Configuration conf, Path samples, Path output, DistanceMeasure measure, int numClusters, int maxIterations, double convergenceDelta) throws IOException {
        ArrayList points = Lists.newArrayList();
        for (int i = 0; i < numClusters; ++i) {
            points.add(((VectorWritable)SAMPLE_DATA.get(i)).get());
        }
        ArrayList initialClusters = Lists.newArrayList();
        int id = 0;
        for (Vector point : points) {
            initialClusters.add(new Kluster(point, id++, measure));
        }
        ClusterClassifier prior = new ClusterClassifier((List)initialClusters, (ClusteringPolicy)new KMeansClusteringPolicy(convergenceDelta));
        Path priorPath = new Path(output, "clusters-0");
        prior.writeToSeqFiles(priorPath);
        ClusterIterator.iterateSeq((Configuration)conf, (Path)samples, (Path)priorPath, (Path)output, (int)maxIterations);
        DisplayKMeans.loadClustersWritable(output);
    }

    private static void runSequentialKMeansClusterer(Configuration conf, Path samples, Path output, DistanceMeasure measure, int numClusters, int maxIterations, double convergenceDelta) throws IOException, InterruptedException, ClassNotFoundException {
        Path clustersIn = new Path(output, "random-seeds");
        RandomSeedGenerator.buildRandom((Configuration)conf, (Path)samples, (Path)clustersIn, (int)numClusters, (DistanceMeasure)measure);
        KMeansDriver.run((Path)samples, (Path)clustersIn, (Path)output, (DistanceMeasure)measure, (double)convergenceDelta, (int)maxIterations, (boolean)true, (double)0.0, (boolean)true);
        DisplayKMeans.loadClustersWritable(output);
    }

    @Override
    public void paint(Graphics g) {
        DisplayKMeans.plotSampleData((Graphics2D)g);
        DisplayKMeans.plotClusters((Graphics2D)g);
    }
}

