/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.display;

import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.clustering.AbstractCluster;
import org.apache.mahout.clustering.Cluster;
import org.apache.mahout.clustering.dirichlet.UncommonDistributions;
import org.apache.mahout.clustering.display.ClustersFilter;
import org.apache.mahout.clustering.iterator.ClusterWritable;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.iterator.sequencefile.PathFilters;
import org.apache.mahout.common.iterator.sequencefile.PathType;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileDirValueIterable;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileIterable;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisplayClustering
extends Frame {
    private static final Logger log = LoggerFactory.getLogger(DisplayClustering.class);
    protected static final int DS = 72;
    protected static final int SIZE = 8;
    private static final Collection<Vector> SAMPLE_PARAMS = Lists.newArrayList();
    protected static final List<VectorWritable> SAMPLE_DATA = Lists.newArrayList();
    protected static final List<List<Cluster>> CLUSTERS = Lists.newArrayList();
    static final Color[] COLORS = new Color[]{Color.red, Color.orange, Color.yellow, Color.green, Color.blue, Color.magenta, Color.lightGray};
    protected static final double T1 = 3.0;
    protected static final double T2 = 2.8;
    static double significance = 0.05;
    protected static int res;

    public DisplayClustering() {
        this.initialize();
        this.setTitle("Sample Data");
    }

    public void initialize() {
        res = Toolkit.getDefaultToolkit().getScreenResolution();
        this.setSize(8 * res, 8 * res);
        this.setVisible(true);
        this.setTitle("Asymmetric Sample Data");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
    }

    public static void main(String[] args) throws Exception {
        RandomUtils.useTestSeed();
        DisplayClustering.generateSamples();
        new DisplayClustering();
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        DisplayClustering.plotSampleData(g2);
        DisplayClustering.plotSampleParameters(g2);
        DisplayClustering.plotClusters(g2);
    }

    protected static void plotClusters(Graphics2D g2) {
        int cx = CLUSTERS.size() - 1;
        for (List<Cluster> clusters : CLUSTERS) {
            g2.setStroke(new BasicStroke(cx == 0 ? 3.0f : 1.0f));
            g2.setColor(COLORS[Math.min(COLORS.length - 1, cx--)]);
            for (Cluster cluster : clusters) {
                DisplayClustering.plotEllipse(g2, cluster.getCenter(), cluster.getRadius().times(3.0));
            }
        }
    }

    protected static void plotSampleParameters(Graphics2D g2) {
        DenseVector v = new DenseVector(2);
        DenseVector dv = new DenseVector(2);
        g2.setColor(Color.RED);
        for (Vector param : SAMPLE_PARAMS) {
            v.set(0, param.get(0));
            v.set(1, param.get(1));
            dv.set(0, param.get(2) * 3.0);
            dv.set(1, param.get(3) * 3.0);
            DisplayClustering.plotEllipse(g2, (Vector)v, (Vector)dv);
        }
    }

    protected static void plotSampleData(Graphics2D g2) {
        double sx = (double)res / 72.0;
        g2.setTransform(AffineTransform.getScaleInstance(sx, sx));
        g2.setColor(Color.BLACK);
        Vector dv = new DenseVector(2).assign(4.0);
        DisplayClustering.plotRectangle(g2, new DenseVector(2).assign(2.0), dv);
        DisplayClustering.plotRectangle(g2, new DenseVector(2).assign(-2.0), dv);
        g2.setColor(Color.DARK_GRAY);
        dv.assign(0.03);
        for (VectorWritable v : SAMPLE_DATA) {
            DisplayClustering.plotRectangle(g2, v.get(), dv);
        }
    }

    protected static void plotClusteredSampleData(Graphics2D g2, Path data) {
        double sx = (double)res / 72.0;
        g2.setTransform(AffineTransform.getScaleInstance(sx, sx));
        g2.setColor(Color.BLACK);
        Vector dv = new DenseVector(2).assign(4.0);
        DisplayClustering.plotRectangle(g2, new DenseVector(2).assign(2.0), dv);
        DisplayClustering.plotRectangle(g2, new DenseVector(2).assign(-2.0), dv);
        dv.assign(0.03);
        Path clusteredPointsPath = new Path(data, "clusteredPoints");
        Path inputPath = new Path(clusteredPointsPath, "part-m-00000");
        HashMap<Integer, Color> colors = new HashMap<Integer, Color>();
        int point = 0;
        for (Pair record : new SequenceFileIterable(inputPath, new Configuration())) {
            int clusterId = ((IntWritable)record.getFirst()).get();
            VectorWritable v = SAMPLE_DATA.get(point++);
            Integer key = clusterId;
            if (!colors.containsKey(key)) {
                colors.put(key, COLORS[Math.min(COLORS.length - 1, colors.size())]);
            }
            DisplayClustering.plotClusteredRectangle(g2, v.get(), dv, (Color)colors.get(key));
        }
    }

    protected static void plotClusteredRectangle(Graphics2D g2, Vector v, Vector dv, Color color) {
        double[] flip = new double[]{1.0, -1.0};
        Vector v2 = v.times((Vector)new DenseVector(flip));
        v2 = v2.minus(dv.divide(2.0));
        int h = 4;
        double x = v2.get(0) + (double)h;
        double y = v2.get(1) + (double)h;
        g2.setStroke(new BasicStroke(1.0f));
        g2.setColor(color);
        g2.draw(new Rectangle2D.Double(x * 72.0, y * 72.0, dv.get(0) * 72.0, dv.get(1) * 72.0));
    }

    protected static void plotRectangle(Graphics2D g2, Vector v, Vector dv) {
        double[] flip = new double[]{1.0, -1.0};
        Vector v2 = v.times((Vector)new DenseVector(flip));
        v2 = v2.minus(dv.divide(2.0));
        int h = 4;
        double x = v2.get(0) + (double)h;
        double y = v2.get(1) + (double)h;
        g2.draw(new Rectangle2D.Double(x * 72.0, y * 72.0, dv.get(0) * 72.0, dv.get(1) * 72.0));
    }

    protected static void plotEllipse(Graphics2D g2, Vector v, Vector dv) {
        double[] flip = new double[]{1.0, -1.0};
        Vector v2 = v.times((Vector)new DenseVector(flip));
        v2 = v2.minus(dv.divide(2.0));
        int h = 4;
        double x = v2.get(0) + (double)h;
        double y = v2.get(1) + (double)h;
        g2.draw(new Ellipse2D.Double(x * 72.0, y * 72.0, dv.get(0) * 72.0, dv.get(1) * 72.0));
    }

    protected static void generateSamples() {
        DisplayClustering.generateSamples(500, 1.0, 1.0, 3.0);
        DisplayClustering.generateSamples(300, 1.0, 0.0, 0.5);
        DisplayClustering.generateSamples(300, 0.0, 2.0, 0.1);
    }

    protected static void generate2dSamples() {
        DisplayClustering.generate2dSamples(500, 1.0, 1.0, 3.0, 1.0);
        DisplayClustering.generate2dSamples(300, 1.0, 0.0, 0.5, 1.0);
        DisplayClustering.generate2dSamples(300, 0.0, 2.0, 0.1, 0.5);
    }

    protected static void generateSamples(int num, double mx, double my, double sd) {
        double[] params = new double[]{mx, my, sd, sd};
        SAMPLE_PARAMS.add((Vector)new DenseVector(params));
        log.info("Generating {} samples m=[{}, {}] sd={}", new Object[]{num, mx, my, sd});
        for (int i = 0; i < num; ++i) {
            SAMPLE_DATA.add(new VectorWritable((Vector)new DenseVector(new double[]{UncommonDistributions.rNorm((double)mx, (double)sd), UncommonDistributions.rNorm((double)my, (double)sd)})));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeSampleData(Path output) throws IOException {
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((URI)output.toUri(), (Configuration)conf);
        SequenceFile.Writer writer = new SequenceFile.Writer(fs, conf, output, Text.class, VectorWritable.class);
        try {
            int i = 0;
            for (VectorWritable vw : SAMPLE_DATA) {
                writer.append((Writable)new Text("sample_" + i++), (Writable)vw);
            }
        }
        finally {
            Closeables.close((Closeable)writer, (boolean)false);
        }
    }

    protected static List<Cluster> readClustersWritable(Path clustersIn) {
        ArrayList clusters = Lists.newArrayList();
        Configuration conf = new Configuration();
        for (ClusterWritable value : new SequenceFileDirValueIterable(clustersIn, PathType.LIST, PathFilters.logsCRCFilter(), conf)) {
            Cluster cluster = value.getValue();
            log.info("Reading Cluster:{} center:{} numPoints:{} radius:{}", new Object[]{cluster.getId(), AbstractCluster.formatVector((Vector)cluster.getCenter(), null), cluster.getNumObservations(), AbstractCluster.formatVector((Vector)cluster.getRadius(), null)});
            clusters.add(cluster);
        }
        return clusters;
    }

    protected static void loadClustersWritable(Path output) throws IOException {
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((URI)output.toUri(), (Configuration)conf);
        for (FileStatus s : fs.listStatus(output, (PathFilter)new ClustersFilter())) {
            List<Cluster> clusters = DisplayClustering.readClustersWritable(s.getPath());
            CLUSTERS.add(clusters);
        }
    }

    protected static void generate2dSamples(int num, double mx, double my, double sdx, double sdy) {
        double[] params = new double[]{mx, my, sdx, sdy};
        SAMPLE_PARAMS.add((Vector)new DenseVector(params));
        log.info("Generating {} samples m=[{}, {}] sd=[{}, {}]", new Object[]{num, mx, my, sdx, sdy});
        for (int i = 0; i < num; ++i) {
            SAMPLE_DATA.add(new VectorWritable((Vector)new DenseVector(new double[]{UncommonDistributions.rNorm((double)mx, (double)sdx), UncommonDistributions.rNorm((double)my, (double)sdy)})));
        }
    }

    protected static boolean isSignificant(Cluster cluster) {
        return (double)cluster.getNumObservations() / (double)SAMPLE_DATA.size() > significance;
    }
}

