/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.display;

import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.swing.Timer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.clustering.display.DisplayClustering;
import org.apache.mahout.clustering.minhash.HashFactory;
import org.apache.mahout.clustering.minhash.MinHashDriver;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.iterator.sequencefile.PathFilters;
import org.apache.mahout.common.iterator.sequencefile.PathType;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileDirIterator;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisplayMinHash
extends DisplayClustering {
    private static final long serialVersionUID = 1L;
    private static transient Logger log = LoggerFactory.getLogger(DisplayMinHash.class);
    private static Map<String, List<Vector>> clusters = new HashMap<String, List<Vector>>();
    private static Iterator<Map.Entry<String, List<Vector>>> currentCluster;
    private static List<Vector> currentClusterPoints;
    private static int updatePeriodTime;
    private static long lastUpdateTime;
    private static boolean isSlideShowOnHold;
    private static int symbolsFontSize;
    private PlotType plotType = PlotType.POINTS;

    public DisplayMinHash(PlotType type) {
        if (type == null) {
            log.error("The PlotType passed should not be null. The program will use the default value - POINTS");
        } else {
            this.plotType = type;
        }
        this.initialize();
        this.setTitle("Minhash Clusters (>" + (int)(significance * 100.0) + "% of population)");
    }

    @Override
    public void paint(Graphics g) {
        DisplayMinHash.plotClusters((Graphics2D)g, this.plotType);
    }

    private static void plotClusters(Graphics2D g2, PlotType plotType) {
        double sx = (double)res / 72.0;
        g2.setTransform(AffineTransform.getScaleInstance(sx, sx));
        Font f = new Font("Dialog", 0, symbolsFontSize);
        g2.setFont(f);
        switch (plotType) {
            case LINES: {
                DisplayMinHash.plotLines(g2);
                break;
            }
            case SYMBOLS: {
                DisplayMinHash.plotSymbols(g2);
                break;
            }
            case POINTS: {
                DisplayMinHash.plotPoints(g2);
                break;
            }
        }
    }

    private static void plotLines(Graphics2D g2) {
        Random rand = new Random();
        for (Map.Entry<String, List<Vector>> entry : clusters.entrySet()) {
            List<Vector> vecs = entry.getValue();
            g2.setColor(new Color(rand.nextInt()));
            for (int i = 0; i < vecs.size(); i += 2) {
                Vector vec2;
                Vector vec1;
                if (i < vecs.size() - 1) {
                    vec1 = vecs.get(i);
                    vec2 = vecs.get(i + 1);
                } else {
                    vec1 = vecs.get(i);
                    vec2 = vecs.get(0);
                }
                DisplayMinHash.plotLine(g2, vec1, vec2);
            }
        }
    }

    private static void plotSymbols(Graphics2D g2) {
        char symbol = '\u0000';
        Random rand = new Random();
        for (Map.Entry<String, List<Vector>> entry : clusters.entrySet()) {
            List<Vector> vecs = entry.getValue();
            g2.setColor(new Color(rand.nextInt()));
            symbol = (char)(symbol + 1);
            for (int i = 0; i < vecs.size(); ++i) {
                DisplayMinHash.plotSymbols(g2, vecs.get(i), symbol);
            }
        }
    }

    private static void plotPoints(Graphics2D g2) {
        if (currentCluster == null || !currentCluster.hasNext()) {
            currentCluster = clusters.entrySet().iterator();
        }
        if (System.currentTimeMillis() - lastUpdateTime > (long)updatePeriodTime) {
            DisplayMinHash.plotSampleData(g2);
            currentClusterPoints = currentCluster.next().getValue();
            lastUpdateTime = System.currentTimeMillis();
        }
        DisplayMinHash.plotSampleData(g2);
        g2.setColor(Color.RED);
        Vector dv = new DenseVector(2).assign(0.03);
        for (int i = 0; i < currentClusterPoints.size(); ++i) {
            DisplayMinHash.plotRectangle(g2, currentClusterPoints.get(i), dv);
        }
    }

    private static void plotSymbols(Graphics2D g2, Vector vec, char symbol) {
        double[] flip = new double[]{1.0, -1.0};
        Vector v1 = vec.times((Vector)new DenseVector(flip));
        int h = 4;
        double x1 = v1.get(0) + (double)h;
        double y1 = v1.get(1) + (double)h;
        g2.drawString(Character.toString(symbol), (int)(x1 * 72.0), (int)(y1 * 72.0));
    }

    private static void plotLine(Graphics2D g2, Vector vec1, Vector vec2) {
        double[] flip = new double[]{1.0, -1.0};
        Vector v1 = vec1.times((Vector)new DenseVector(flip));
        Vector v2 = vec2.times((Vector)new DenseVector(flip));
        int h = 4;
        double x1 = v1.get(0) + (double)h;
        double y1 = v1.get(1) + (double)h;
        double x2 = v2.get(0) + (double)h;
        double y2 = v2.get(1) + (double)h;
        g2.draw(new Line2D.Double(x1 * 72.0, y1 * 72.0, x2 * 72.0, y2 * 72.0));
    }

    public static void main(String[] args) throws Exception {
        Path samples = new Path("samples");
        Path output = new Path("output", "minhash");
        PlotType type = DisplayMinHash.determinePlotType(args);
        updatePeriodTime = DisplayMinHash.determineUpdatePeriodTime(args);
        Configuration conf = new Configuration();
        HadoopUtil.delete((Configuration)conf, (Path[])new Path[]{samples});
        HadoopUtil.delete((Configuration)conf, (Path[])new Path[]{output});
        RandomUtils.useTestSeed();
        DisplayMinHash.generateSamples();
        DisplayMinHash.writeSampleData(samples);
        DisplayMinHash.runMinHash(conf, samples, output);
        DisplayMinHash.loadClusters(output);
        DisplayMinHash.logClusters();
        final DisplayMinHash f = new DisplayMinHash(type);
        if (type == PlotType.POINTS) {
            Timer timer = new Timer(updatePeriodTime, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DisplayMinHash.repaint(f);
                }
            });
            timer.start();
        }
        f.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent arg0) {
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
            }

            @Override
            public void keyPressed(KeyEvent arg0) {
                if (arg0.getKeyCode() == 32) {
                    DisplayMinHash.onSpacePressed();
                }
            }
        });
    }

    private static PlotType determinePlotType(String[] args) {
        PlotType type = PlotType.POINTS;
        if (args.length != 0) {
            if (args[0].equals("-p")) {
                type = PlotType.POINTS;
            } else if (args[0].equals("-l")) {
                type = PlotType.LINES;
            } else if (args[0].equals("-s")) {
                type = PlotType.SYMBOLS;
            } else {
                System.out.println("Wrong parameter: -p (plot points); -l (plot lines); -s (plot symbols)");
            }
        }
        return type;
    }

    private static int determineUpdatePeriodTime(String[] args) {
        int updatePeriodTimeInMinutes = 1;
        if (args.length >= 2) {
            try {
                updatePeriodTime = Integer.parseInt(args[1]);
            }
            catch (Exception e) {
                System.out.println(args[1] + " isn't valid integer value. 1 second will be used.");
            }
        }
        return updatePeriodTimeInMinutes * 1000;
    }

    private static void repaint(Frame f) {
        if (!isSlideShowOnHold) {
            f.repaint();
        }
    }

    private static void onSpacePressed() {
        isSlideShowOnHold = !isSlideShowOnHold;
    }

    private static void logClusters() {
        int i = 0;
        for (Map.Entry<String, List<Vector>> entry : clusters.entrySet()) {
            String logStr = "Cluster N:" + ++i + ": ";
            List<Vector> vecs = entry.getValue();
            for (Vector vector : vecs) {
                logStr = logStr + vector.get(0);
                logStr = logStr + ",";
                logStr = logStr + vector.get(1);
                logStr = logStr + "; ";
            }
            log.info(logStr);
        }
    }

    protected static void loadClusters(Path output) throws IOException {
        Configuration conf = new Configuration();
        SequenceFileDirIterator iterator = new SequenceFileDirIterator(output, PathType.LIST, PathFilters.partFilter(), null, false, conf);
        while (iterator.hasNext()) {
            Pair next = (Pair)iterator.next();
            String key = ((Text)next.getFirst()).toString();
            List<Vector> list = clusters.get(key);
            if (list == null) {
                list = new ArrayList<Vector>();
                clusters.put(key, list);
            }
            list.add(((VectorWritable)next.getSecond()).get());
        }
        log.info("Loaded: " + clusters.size() + " clusters");
    }

    private static void runMinHash(Configuration conf, Path samples, Path output) throws Exception {
        MinHashDriver mhd = new MinHashDriver();
        ToolRunner.run((Configuration)conf, (Tool)mhd, (String[])new String[]{"--input", samples.toString(), "--hashType", HashFactory.HashType.MURMUR3.toString(), "--output", output.toString(), "--minVectorSize", "1", "--debugOutput"});
    }

    static {
        lastUpdateTime = 0L;
        isSlideShowOnHold = false;
        symbolsFontSize = 6;
    }

    public static enum PlotType {
        LINES,
        POINTS,
        SYMBOLS;

    }
}

