/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.sgd;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Collection;
import org.apache.commons.cli2.CommandLine;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.builder.ArgumentBuilder;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.commons.cli2.builder.GroupBuilder;
import org.apache.commons.cli2.commandline.Parser;
import org.apache.commons.cli2.option.DefaultOption;
import org.apache.commons.cli2.util.HelpFormatter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.Text;
import org.apache.mahout.classifier.ClassifierResult;
import org.apache.mahout.classifier.ResultAnalyzer;
import org.apache.mahout.classifier.sgd.ModelSerializer;
import org.apache.mahout.classifier.sgd.OnlineLogisticRegression;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.iterator.sequencefile.PathType;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileDirIterator;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.vectorizer.encoders.Dictionary;

public final class TestASFEmail {
    private String inputFile;
    private String modelFile;

    private TestASFEmail() {
    }

    public static void main(String[] args) throws IOException {
        TestASFEmail runner = new TestASFEmail();
        if (runner.parseArgs(args)) {
            runner.run(new PrintWriter(System.out, true));
        }
    }

    public void run(PrintWriter output) throws IOException {
        File base = new File(this.inputFile);
        OnlineLogisticRegression classifier = (OnlineLogisticRegression)ModelSerializer.readBinary((InputStream)new FileInputStream(this.modelFile), OnlineLogisticRegression.class);
        Dictionary asfDictionary = new Dictionary();
        Configuration conf = new Configuration();
        PathFilter testFilter = new PathFilter(){

            public boolean accept(Path path) {
                return path.getName().contains("test");
            }
        };
        SequenceFileDirIterator iter = new SequenceFileDirIterator(new Path(base.toString()), PathType.LIST, testFilter, null, true, conf);
        long numItems = 0L;
        while (iter.hasNext()) {
            Pair next = (Pair)iter.next();
            asfDictionary.intern(((Text)next.getFirst()).toString());
            ++numItems;
        }
        System.out.printf("%d test files\n", numItems);
        ResultAnalyzer ra = new ResultAnalyzer((Collection)asfDictionary.values(), "DEFAULT");
        iter = new SequenceFileDirIterator(new Path(base.toString()), PathType.LIST, testFilter, null, true, conf);
        while (iter.hasNext()) {
            Pair next = (Pair)iter.next();
            String ng = ((Text)next.getFirst()).toString();
            int actual = asfDictionary.intern(ng);
            Vector result = classifier.classifyFull(((VectorWritable)next.getSecond()).get());
            int cat = result.maxValueIndex();
            double score = result.maxValue();
            double ll = classifier.logLikelihood(actual, ((VectorWritable)next.getSecond()).get());
            ClassifierResult cr = new ClassifierResult((String)asfDictionary.values().get(cat), score, ll);
            ra.addInstance((String)asfDictionary.values().get(actual), cr);
        }
        output.printf("%s\n\n", ra.toString());
    }

    boolean parseArgs(String[] args) {
        DefaultOptionBuilder builder = new DefaultOptionBuilder();
        DefaultOption help = builder.withLongName("help").withDescription("print this list").create();
        ArgumentBuilder argumentBuilder = new ArgumentBuilder();
        DefaultOption inputFileOption = builder.withLongName("input").withRequired(true).withArgument(argumentBuilder.withName("input").withMaximum(1).create()).withDescription("where to get training data").create();
        DefaultOption modelFileOption = builder.withLongName("model").withRequired(true).withArgument(argumentBuilder.withName("model").withMaximum(1).create()).withDescription("where to get a model").create();
        Group normalArgs = new GroupBuilder().withOption((Option)help).withOption((Option)inputFileOption).withOption((Option)modelFileOption).create();
        Parser parser = new Parser();
        parser.setHelpOption((Option)help);
        parser.setHelpTrigger("--help");
        parser.setGroup(normalArgs);
        parser.setHelpFormatter(new HelpFormatter(" ", "", " ", 130));
        CommandLine cmdLine = parser.parseAndHelp(args);
        if (cmdLine == null) {
            return false;
        }
        this.inputFile = (String)cmdLine.getValue((Option)inputFileOption);
        this.modelFile = (String)cmdLine.getValue((Option)modelFileOption);
        return true;
    }
}

