/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.sgd;

import java.io.BufferedReader;
import java.io.File;
import java.io.PrintWriter;
import java.util.Locale;
import org.apache.commons.cli2.CommandLine;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.builder.ArgumentBuilder;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.commons.cli2.builder.GroupBuilder;
import org.apache.commons.cli2.commandline.Parser;
import org.apache.commons.cli2.option.DefaultOption;
import org.apache.commons.cli2.util.HelpFormatter;
import org.apache.mahout.classifier.evaluation.Auc;
import org.apache.mahout.classifier.sgd.CsvRecordFactory;
import org.apache.mahout.classifier.sgd.LogisticModelParameters;
import org.apache.mahout.classifier.sgd.OnlineLogisticRegression;
import org.apache.mahout.classifier.sgd.TrainLogistic;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.SequentialAccessSparseVector;
import org.apache.mahout.math.Vector;

public final class RunLogistic {
    private static String inputFile;
    private static String modelFile;
    private static boolean showAuc;
    private static boolean showScores;
    private static boolean showConfusion;

    private RunLogistic() {
    }

    public static void main(String[] args) throws Exception {
        RunLogistic.mainToOutput(args, new PrintWriter(System.out, true));
    }

    static void mainToOutput(String[] args, PrintWriter output) throws Exception {
        if (RunLogistic.parseArgs(args)) {
            if (!(showAuc || showConfusion || showScores)) {
                showAuc = true;
                showConfusion = true;
            }
            Auc collector = new Auc();
            LogisticModelParameters lmp = LogisticModelParameters.loadFrom(new File(modelFile));
            CsvRecordFactory csv = lmp.getCsvRecordFactory();
            OnlineLogisticRegression lr = lmp.createRegression();
            BufferedReader in = TrainLogistic.open(inputFile);
            String line = in.readLine();
            csv.firstLine(line);
            line = in.readLine();
            if (showScores) {
                output.printf(Locale.ENGLISH, "\"%s\",\"%s\",\"%s\"\n", "target", "model-output", "log-likelihood");
            }
            while (line != null) {
                SequentialAccessSparseVector v = new SequentialAccessSparseVector(lmp.getNumFeatures());
                int target = csv.processLine(line, (Vector)v);
                double score = lr.classifyScalar((Vector)v);
                if (showScores) {
                    output.printf(Locale.ENGLISH, "%d,%.3f,%.6f\n", target, score, lr.logLikelihood(target, (Vector)v));
                }
                collector.add(target, score);
                line = in.readLine();
            }
            if (showAuc) {
                output.printf(Locale.ENGLISH, "AUC = %.2f\n", collector.auc());
            }
            if (showConfusion) {
                Matrix m = collector.confusion();
                output.printf(Locale.ENGLISH, "confusion: [[%.1f, %.1f], [%.1f, %.1f]]\n", m.get(0, 0), m.get(1, 0), m.get(0, 1), m.get(1, 1));
                m = collector.entropy();
                output.printf(Locale.ENGLISH, "entropy: [[%.1f, %.1f], [%.1f, %.1f]]\n", m.get(0, 0), m.get(1, 0), m.get(0, 1), m.get(1, 1));
            }
        }
    }

    private static boolean parseArgs(String[] args) {
        DefaultOptionBuilder builder = new DefaultOptionBuilder();
        DefaultOption help = builder.withLongName("help").withDescription("print this list").create();
        DefaultOption quiet = builder.withLongName("quiet").withDescription("be extra quiet").create();
        DefaultOption auc = builder.withLongName("auc").withDescription("print AUC").create();
        DefaultOption confusion = builder.withLongName("confusion").withDescription("print confusion matrix").create();
        DefaultOption scores = builder.withLongName("scores").withDescription("print scores").create();
        ArgumentBuilder argumentBuilder = new ArgumentBuilder();
        DefaultOption inputFileOption = builder.withLongName("input").withRequired(true).withArgument(argumentBuilder.withName("input").withMaximum(1).create()).withDescription("where to get training data").create();
        DefaultOption modelFileOption = builder.withLongName("model").withRequired(true).withArgument(argumentBuilder.withName("model").withMaximum(1).create()).withDescription("where to get a model").create();
        Group normalArgs = new GroupBuilder().withOption((Option)help).withOption((Option)quiet).withOption((Option)auc).withOption((Option)scores).withOption((Option)confusion).withOption((Option)inputFileOption).withOption((Option)modelFileOption).create();
        Parser parser = new Parser();
        parser.setHelpOption((Option)help);
        parser.setHelpTrigger("--help");
        parser.setGroup(normalArgs);
        parser.setHelpFormatter(new HelpFormatter(" ", "", " ", 130));
        CommandLine cmdLine = parser.parseAndHelp(args);
        if (cmdLine == null) {
            return false;
        }
        inputFile = RunLogistic.getStringArgument(cmdLine, (Option)inputFileOption);
        modelFile = RunLogistic.getStringArgument(cmdLine, (Option)modelFileOption);
        showAuc = RunLogistic.getBooleanArgument(cmdLine, (Option)auc);
        showScores = RunLogistic.getBooleanArgument(cmdLine, (Option)scores);
        showConfusion = RunLogistic.getBooleanArgument(cmdLine, (Option)confusion);
        return true;
    }

    private static boolean getBooleanArgument(CommandLine cmdLine, Option option) {
        return cmdLine.hasOption(option);
    }

    private static String getStringArgument(CommandLine cmdLine, Option inputFile) {
        return (String)cmdLine.getValue(inputFile);
    }
}

