/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.sgd;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.cli2.CommandLine;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.builder.ArgumentBuilder;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.commons.cli2.builder.GroupBuilder;
import org.apache.commons.cli2.commandline.Parser;
import org.apache.commons.cli2.option.DefaultOption;
import org.apache.commons.cli2.util.HelpFormatter;
import org.apache.mahout.classifier.sgd.AdaptiveLogisticModelParameters;
import org.apache.mahout.classifier.sgd.AdaptiveLogisticRegression;
import org.apache.mahout.classifier.sgd.CrossFoldLearner;
import org.apache.mahout.classifier.sgd.CsvRecordFactory;
import org.apache.mahout.classifier.sgd.TrainAdaptiveLogistic;
import org.apache.mahout.ep.State;
import org.apache.mahout.math.SequentialAccessSparseVector;
import org.apache.mahout.math.Vector;

public final class RunAdaptiveLogistic {
    private static String inputFile;
    private static String modelFile;
    private static String outputFile;
    private static String idColumn;
    private static boolean maxScoreOnly;

    private RunAdaptiveLogistic() {
    }

    public static void main(String[] args) throws Exception {
        RunAdaptiveLogistic.mainToOutput(args, new PrintWriter(System.out, true));
    }

    static void mainToOutput(String[] args, PrintWriter output) throws Exception {
        if (!RunAdaptiveLogistic.parseArgs(args)) {
            return;
        }
        AdaptiveLogisticModelParameters lmp = AdaptiveLogisticModelParameters.loadFromFile(new File(modelFile));
        CsvRecordFactory csv = lmp.getCsvRecordFactory();
        csv.setIdName(idColumn);
        AdaptiveLogisticRegression lr = lmp.createAdaptiveLogisticRegression();
        State best = lr.getBest();
        if (best == null) {
            output.printf("%s\n", "AdaptiveLogisticRegression has not be trained probably.");
            return;
        }
        CrossFoldLearner learner = ((AdaptiveLogisticRegression.Wrapper)best.getPayload()).getLearner();
        BufferedReader in = TrainAdaptiveLogistic.open(inputFile);
        BufferedWriter out = new BufferedWriter(new FileWriter(outputFile));
        out.write(idColumn + ",target,score");
        out.newLine();
        String line = in.readLine();
        csv.firstLine(line);
        line = in.readLine();
        HashMap<String, Double> results = new HashMap<String, Double>();
        int k = 0;
        while (line != null) {
            SequentialAccessSparseVector v = new SequentialAccessSparseVector(lmp.getNumFeatures());
            csv.processLine((CharSequence)line, (Vector)v, false);
            Vector scores = learner.classifyFull((Vector)v);
            results.clear();
            if (maxScoreOnly) {
                results.put(csv.getTargetLabel(scores.maxValueIndex()), scores.maxValue());
            } else {
                for (int i = 0; i < scores.size(); ++i) {
                    results.put(csv.getTargetLabel(i), scores.get(i));
                }
            }
            for (Map.Entry entry : results.entrySet()) {
                out.write(csv.getIdString((CharSequence)line) + ',' + (String)entry.getKey() + ',' + entry.getValue());
                out.newLine();
            }
            if (++k % 100 == 0) {
                output.printf(Locale.ENGLISH, "%d records processed \n", k);
            }
            line = in.readLine();
        }
        out.flush();
        out.close();
        output.printf(Locale.ENGLISH, "%d records processed totally.\n", k);
    }

    private static boolean parseArgs(String[] args) {
        DefaultOptionBuilder builder = new DefaultOptionBuilder();
        DefaultOption help = builder.withLongName("help").withDescription("print this list").create();
        DefaultOption quiet = builder.withLongName("quiet").withDescription("be extra quiet").create();
        ArgumentBuilder argumentBuilder = new ArgumentBuilder();
        DefaultOption inputFileOption = builder.withLongName("input").withRequired(true).withArgument(argumentBuilder.withName("input").withMaximum(1).create()).withDescription("where to get training data").create();
        DefaultOption modelFileOption = builder.withLongName("model").withRequired(true).withArgument(argumentBuilder.withName("model").withMaximum(1).create()).withDescription("where to get the trained model").create();
        DefaultOption outputFileOption = builder.withLongName("output").withRequired(true).withDescription("the file path to output scores").withArgument(argumentBuilder.withName("output").withMaximum(1).create()).create();
        DefaultOption idColumnOption = builder.withLongName("idcolumn").withRequired(true).withDescription("the name of the id column for each record").withArgument(argumentBuilder.withName("idcolumn").withMaximum(1).create()).create();
        DefaultOption maxScoreOnlyOption = builder.withLongName("maxscoreonly").withDescription("only output the target label with max scores").create();
        Group normalArgs = new GroupBuilder().withOption((Option)help).withOption((Option)quiet).withOption((Option)inputFileOption).withOption((Option)modelFileOption).withOption((Option)outputFileOption).withOption((Option)idColumnOption).withOption((Option)maxScoreOnlyOption).create();
        Parser parser = new Parser();
        parser.setHelpOption((Option)help);
        parser.setHelpTrigger("--help");
        parser.setGroup(normalArgs);
        parser.setHelpFormatter(new HelpFormatter(" ", "", " ", 130));
        CommandLine cmdLine = parser.parseAndHelp(args);
        if (cmdLine == null) {
            return false;
        }
        inputFile = RunAdaptiveLogistic.getStringArgument(cmdLine, (Option)inputFileOption);
        modelFile = RunAdaptiveLogistic.getStringArgument(cmdLine, (Option)modelFileOption);
        outputFile = RunAdaptiveLogistic.getStringArgument(cmdLine, (Option)outputFileOption);
        idColumn = RunAdaptiveLogistic.getStringArgument(cmdLine, (Option)idColumnOption);
        maxScoreOnly = RunAdaptiveLogistic.getBooleanArgument(cmdLine, (Option)maxScoreOnlyOption);
        return true;
    }

    private static boolean getBooleanArgument(CommandLine cmdLine, Option option) {
        return cmdLine.hasOption(option);
    }

    private static String getStringArgument(CommandLine cmdLine, Option inputFile) {
        return (String)cmdLine.getValue(inputFile);
    }
}

