/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop.example.als.netflix;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.mahout.cf.taste.impl.model.GenericPreference;
import org.apache.mahout.cf.taste.model.Preference;
import org.apache.mahout.common.iterator.FileLineIterable;
import org.apache.mahout.common.iterator.FileLineIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetflixDatasetConverter {
    private static final Logger log = LoggerFactory.getLogger(NetflixDatasetConverter.class);
    private static final Pattern SEPARATOR = Pattern.compile(",");
    private static final String MOVIE_DENOTER = ":";
    private static final String TAB = "\t";
    private static final String NEWLINE = "\n";

    private NetflixDatasetConverter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        if (args.length != 4) {
            System.err.println("Usage: NetflixDatasetConverter /path/to/training_set/ /path/to/qualifying.txt /path/to/judging.txt /path/to/destination");
            return;
        }
        String trainingDataDir = args[0];
        String qualifyingTxt = args[1];
        String judgingTxt = args[2];
        Path outputPath = new Path(args[3]);
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((URI)outputPath.toUri(), (Configuration)conf);
        log.info("Creating training set at {}/trainingSet/ratings.tsv ...", (Object)outputPath);
        BufferedWriter writer = null;
        try {
            FSDataOutputStream outputStream = fs.create(new Path(outputPath, "trainingSet/ratings.tsv"));
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)outputStream, Charsets.UTF_8));
            int ratingsProcessed = 0;
            for (File movieRatings : new File(trainingDataDir).listFiles()) {
                FileLineIterator lines = null;
                try {
                    lines = new FileLineIterator(movieRatings);
                    boolean firstLineRead = false;
                    String movieID = null;
                    while (lines.hasNext()) {
                        String line = (String)lines.next();
                        if (firstLineRead) {
                            String[] tokens = SEPARATOR.split(line);
                            String userID = tokens[0];
                            String rating = tokens[1];
                            writer.write(userID + TAB + movieID + TAB + rating + NEWLINE);
                            if (++ratingsProcessed % 1000000 != 0) continue;
                            log.info("{} ratings processed...", (Object)ratingsProcessed);
                            continue;
                        }
                        movieID = line.replaceAll(MOVIE_DENOTER, "");
                        firstLineRead = true;
                    }
                }
                catch (Throwable throwable) {
                    Closeables.closeQuietly(lines);
                    throw throwable;
                }
                Closeables.closeQuietly((Closeable)lines);
            }
            log.info("{} ratings processed. done.", (Object)ratingsProcessed);
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly(writer);
            throw throwable;
        }
        Closeables.closeQuietly((Closeable)writer);
        log.info("Reading probes...");
        ArrayList probes = Lists.newArrayListWithExpectedSize((int)2817131);
        long currentMovieID = -1L;
        for (String line : new FileLineIterable(new File(qualifyingTxt))) {
            if (line.contains(MOVIE_DENOTER)) {
                currentMovieID = Long.parseLong(line.replaceAll(MOVIE_DENOTER, ""));
                continue;
            }
            long userID = Long.parseLong(SEPARATOR.split(line)[0]);
            probes.add(new GenericPreference(userID, currentMovieID, 0.0f));
        }
        log.info("{} probes read...", (Object)probes.size());
        log.info("Reading ratings, creating probe set at {}/probeSet/ratings.tsv ...", (Object)outputPath);
        writer = null;
        try {
            FSDataOutputStream outputStream = fs.create(new Path(outputPath, "probeSet/ratings.tsv"));
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)outputStream, Charsets.UTF_8));
            int ratingsProcessed = 0;
            for (String line : new FileLineIterable(new File(judgingTxt))) {
                if (line.contains(MOVIE_DENOTER)) {
                    currentMovieID = Long.parseLong(line.replaceAll(MOVIE_DENOTER, ""));
                    continue;
                }
                float rating = Float.parseFloat(SEPARATOR.split(line)[0]);
                Preference pref = (Preference)probes.get(ratingsProcessed);
                Preconditions.checkState((pref.getItemID() == currentMovieID ? 1 : 0) != 0);
                writer.write(pref.getUserID() + TAB + pref.getItemID() + TAB + rating + NEWLINE);
                if (++ratingsProcessed % 1000000 != 0) continue;
                log.info("{} ratings processed...", (Object)ratingsProcessed);
            }
            log.info("{} ratings processed. done.", (Object)ratingsProcessed);
        }
        finally {
            Closeables.closeQuietly((Closeable)writer);
        }
    }
}

