/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.example.kddcup.track2;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.mahout.cf.taste.common.NoSuchItemException;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.example.kddcup.track2.UserResult;
import org.apache.mahout.cf.taste.model.PreferenceArray;
import org.apache.mahout.cf.taste.recommender.Recommender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Track2Callable
implements Callable<UserResult> {
    private static final Logger log = LoggerFactory.getLogger(Track2Callable.class);
    private static final AtomicInteger COUNT = new AtomicInteger();
    private final Recommender recommender;
    private final PreferenceArray userTest;

    Track2Callable(Recommender recommender, PreferenceArray userTest) {
        this.recommender = recommender;
        this.userTest = userTest;
    }

    @Override
    public UserResult call() throws TasteException {
        int testSize = this.userTest.length();
        if (testSize != 6) {
            throw new IllegalArgumentException("Expecting 6 items for user but got " + this.userTest);
        }
        long userID = this.userTest.get(0).getUserID();
        TreeMap estimateToItemID = new TreeMap(Collections.reverseOrder());
        for (int i = 0; i < testSize; ++i) {
            double estimate;
            long itemID = this.userTest.getItemID(i);
            try {
                estimate = this.recommender.estimatePreference(userID, itemID);
            }
            catch (NoSuchItemException nsie) {
                log.warn("Unknown item {}; OK unless this is the real contest data", (Object)itemID);
                continue;
            }
            if (Double.isNaN(estimate)) continue;
            estimateToItemID.put(estimate, itemID);
        }
        Collection itemIDs = estimateToItemID.values();
        List topThree = Lists.newArrayList(itemIDs);
        if (topThree.size() > 3) {
            topThree = topThree.subList(0, 3);
        } else if (topThree.size() < 3) {
            log.warn("Unable to recommend three items for {}", (Object)userID);
            HashSet<Object> newItemIDs = new HashSet<Object>(3);
            newItemIDs.addAll(itemIDs);
            for (int i = 0; i < testSize && newItemIDs.size() < 3; ++i) {
                newItemIDs.add(this.userTest.getItemID(i));
            }
            topThree = Lists.newArrayList(newItemIDs);
        }
        if (topThree.size() != 3) {
            throw new IllegalStateException();
        }
        boolean[] result = new boolean[testSize];
        for (int i = 0; i < testSize; ++i) {
            result[i] = topThree.contains(this.userTest.getItemID(i));
        }
        if (COUNT.incrementAndGet() % 1000 == 0) {
            log.info("Completed {} users", (Object)COUNT.get());
        }
        return new UserResult(userID, result);
    }
}

