/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.example.kddcup.track1.svd;

import com.google.common.io.Closeables;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.mahout.cf.taste.common.NoSuchItemException;
import org.apache.mahout.cf.taste.common.NoSuchUserException;
import org.apache.mahout.cf.taste.example.kddcup.DataFileIterable;
import org.apache.mahout.cf.taste.example.kddcup.KDDCupDataModel;
import org.apache.mahout.cf.taste.example.kddcup.track1.EstimateConverter;
import org.apache.mahout.cf.taste.example.kddcup.track1.svd.KDDCupFactorizablePreferences;
import org.apache.mahout.cf.taste.example.kddcup.track1.svd.ParallelArraysSGDFactorizer;
import org.apache.mahout.cf.taste.impl.common.FullRunningAverage;
import org.apache.mahout.cf.taste.impl.recommender.svd.Factorization;
import org.apache.mahout.cf.taste.model.Preference;
import org.apache.mahout.cf.taste.model.PreferenceArray;
import org.apache.mahout.common.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Track1SVDRunner {
    private static final Logger log = LoggerFactory.getLogger(Track1SVDRunner.class);

    private Track1SVDRunner() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("Necessary arguments: <kddDataFileDirectory> <resultFile>");
            return;
        }
        File dataFileDirectory = new File(args[0]);
        if (!dataFileDirectory.exists() || !dataFileDirectory.isDirectory()) {
            throw new IllegalArgumentException("Bad data file directory: " + dataFileDirectory);
        }
        File resultFile = new File(args[1]);
        int numFeatures = 20;
        int numIterations = 5;
        double learningRate = 1.0E-4;
        double preventOverfitting = 0.002;
        double randomNoise = 1.0E-4;
        KDDCupFactorizablePreferences factorizablePreferences = new KDDCupFactorizablePreferences(KDDCupDataModel.getTrainingFile(dataFileDirectory));
        ParallelArraysSGDFactorizer sgdFactorizer = new ParallelArraysSGDFactorizer(factorizablePreferences, numFeatures, numIterations, learningRate, preventOverfitting, randomNoise);
        Factorization factorization = sgdFactorizer.factorize();
        log.info("Estimating validation preferences...");
        int prefsProcessed = 0;
        FullRunningAverage average = new FullRunningAverage();
        for (Pair<PreferenceArray, long[]> validationPair : new DataFileIterable(KDDCupDataModel.getValidationFile(dataFileDirectory))) {
            for (Preference validationPref : (PreferenceArray)validationPair.getFirst()) {
                double estimate = Track1SVDRunner.estimatePreference(factorization, validationPref.getUserID(), validationPref.getItemID(), factorizablePreferences.getMinPreference(), factorizablePreferences.getMaxPreference());
                double error = (double)validationPref.getValue() - estimate;
                average.addDatum(error * error);
                if (++prefsProcessed % 100000 != 0) continue;
                log.info("Computed {} estimations", (Object)prefsProcessed);
            }
        }
        log.info("Computed {} estimations, done.", (Object)prefsProcessed);
        double rmse = Math.sqrt(average.getAverage());
        log.info("RMSE {}", (Object)rmse);
        log.info("Estimating test preferences...");
        BufferedOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(resultFile));
            for (Pair<PreferenceArray, long[]> testPair : new DataFileIterable(KDDCupDataModel.getTestFile(dataFileDirectory))) {
                for (Preference testPref : (PreferenceArray)testPair.getFirst()) {
                    double estimate = Track1SVDRunner.estimatePreference(factorization, testPref.getUserID(), testPref.getItemID(), factorizablePreferences.getMinPreference(), factorizablePreferences.getMaxPreference());
                    byte result = EstimateConverter.convert(estimate, testPref.getUserID(), testPref.getItemID());
                    ((OutputStream)out).write(result);
                }
            }
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly(out);
            throw throwable;
        }
        Closeables.closeQuietly((Closeable)out);
        log.info("wrote estimates to {}, done.", (Object)resultFile.getAbsolutePath());
    }

    static double estimatePreference(Factorization factorization, long userID, long itemID, float minPreference, float maxPreference) throws NoSuchUserException, NoSuchItemException {
        double[] userFeatures = factorization.getUserFeatures(userID);
        double[] itemFeatures = factorization.getItemFeatures(itemID);
        double estimate = 0.0;
        for (int feature = 0; feature < userFeatures.length; ++feature) {
            estimate += userFeatures[feature] * itemFeatures[feature];
        }
        if (estimate < (double)minPreference) {
            estimate = minPreference;
        } else if (estimate > (double)maxPreference) {
            estimate = maxPreference;
        }
        return estimate;
    }
}

