/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.example.kddcup.track1;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EstimateConverter {
    private static final Logger log = LoggerFactory.getLogger(EstimateConverter.class);

    private EstimateConverter() {
    }

    public static byte convert(double estimate, long userID, long itemID) {
        if (Double.isNaN(estimate)) {
            log.warn("Unable to compute estimate for user {}, item {}", (Object)userID, (Object)itemID);
            return 127;
        }
        int scaledEstimate = (int)(estimate * 2.55);
        if (scaledEstimate > 255) {
            scaledEstimate = 255;
        } else if (scaledEstimate < 0) {
            scaledEstimate = 0;
        }
        return (byte)scaledEstimate;
    }
}

