/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.example.grouplens;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.example.grouplens.GroupLensDataModel;
import org.apache.mahout.cf.taste.impl.recommender.CachingRecommender;
import org.apache.mahout.cf.taste.impl.recommender.slopeone.SlopeOneRecommender;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.recommender.IDRescorer;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.apache.mahout.cf.taste.recommender.Recommender;

public final class GroupLensRecommender
implements Recommender {
    private final Recommender recommender;

    public GroupLensRecommender() throws IOException, TasteException {
        this((DataModel)new GroupLensDataModel());
    }

    public GroupLensRecommender(DataModel dataModel) throws TasteException {
        this.recommender = new CachingRecommender((Recommender)new SlopeOneRecommender(dataModel));
    }

    public List<RecommendedItem> recommend(long userID, int howMany) throws TasteException {
        return this.recommender.recommend(userID, howMany);
    }

    public List<RecommendedItem> recommend(long userID, int howMany, IDRescorer rescorer) throws TasteException {
        return this.recommender.recommend(userID, howMany, rescorer);
    }

    public float estimatePreference(long userID, long itemID) throws TasteException {
        return this.recommender.estimatePreference(userID, itemID);
    }

    public void setPreference(long userID, long itemID, float value) throws TasteException {
        this.recommender.setPreference(userID, itemID, value);
    }

    public void removePreference(long userID, long itemID) throws TasteException {
        this.recommender.removePreference(userID, itemID);
    }

    public DataModel getDataModel() {
        return this.recommender.getDataModel();
    }

    public void refresh(Collection<Refreshable> alreadyRefreshed) {
        this.recommender.refresh(alreadyRefreshed);
    }

    public String toString() {
        return "GroupLensRecommender[recommender:" + this.recommender + ']';
    }
}

