/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.df.mapreduce;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import java.util.Scanner;
import org.apache.commons.cli2.CommandLine;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.OptionException;
import org.apache.commons.cli2.builder.ArgumentBuilder;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.commons.cli2.builder.GroupBuilder;
import org.apache.commons.cli2.commandline.Parser;
import org.apache.commons.cli2.option.DefaultOption;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.classifier.ClassifierResult;
import org.apache.mahout.classifier.RegressionResultAnalyzer;
import org.apache.mahout.classifier.ResultAnalyzer;
import org.apache.mahout.classifier.df.DFUtils;
import org.apache.mahout.classifier.df.DecisionForest;
import org.apache.mahout.classifier.df.data.DataConverter;
import org.apache.mahout.classifier.df.data.Dataset;
import org.apache.mahout.classifier.df.data.Instance;
import org.apache.mahout.classifier.df.mapreduce.Classifier;
import org.apache.mahout.common.CommandLineUtil;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.RandomWrapper;
import org.apache.mahout.common.commandline.DefaultOptionCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestForest
extends Configured
implements Tool {
    private static final Logger log = LoggerFactory.getLogger(TestForest.class);
    private FileSystem dataFS;
    private Path dataPath;
    private Path datasetPath;
    private Path modelPath;
    private FileSystem outFS;
    private Path outputPath;
    private boolean analyze;
    private boolean useMapreduce;

    public int run(String[] args) throws IOException, ClassNotFoundException, InterruptedException {
        DefaultOptionBuilder obuilder = new DefaultOptionBuilder();
        ArgumentBuilder abuilder = new ArgumentBuilder();
        GroupBuilder gbuilder = new GroupBuilder();
        DefaultOption inputOpt = DefaultOptionCreator.inputOption().create();
        DefaultOption datasetOpt = obuilder.withLongName("dataset").withShortName("ds").withRequired(true).withArgument(abuilder.withName("dataset").withMinimum(1).withMaximum(1).create()).withDescription("Dataset path").create();
        DefaultOption modelOpt = obuilder.withLongName("model").withShortName("m").withRequired(true).withArgument(abuilder.withName("path").withMinimum(1).withMaximum(1).create()).withDescription("Path to the Decision Forest").create();
        DefaultOption outputOpt = DefaultOptionCreator.outputOption().create();
        DefaultOption analyzeOpt = obuilder.withLongName("analyze").withShortName("a").withRequired(false).create();
        DefaultOption mrOpt = obuilder.withLongName("mapreduce").withShortName("mr").withRequired(false).create();
        Option helpOpt = DefaultOptionCreator.helpOption();
        Group group = gbuilder.withName("Options").withOption((Option)inputOpt).withOption((Option)datasetOpt).withOption((Option)modelOpt).withOption((Option)outputOpt).withOption((Option)analyzeOpt).withOption((Option)mrOpt).withOption(helpOpt).create();
        try {
            Parser parser = new Parser();
            parser.setGroup(group);
            CommandLine cmdLine = parser.parse(args);
            if (cmdLine.hasOption("help")) {
                CommandLineUtil.printHelp((Group)group);
                return -1;
            }
            String dataName = cmdLine.getValue((Option)inputOpt).toString();
            String datasetName = cmdLine.getValue((Option)datasetOpt).toString();
            String modelName = cmdLine.getValue((Option)modelOpt).toString();
            String outputName = cmdLine.hasOption((Option)outputOpt) ? cmdLine.getValue((Option)outputOpt).toString() : null;
            this.analyze = cmdLine.hasOption((Option)analyzeOpt);
            this.useMapreduce = cmdLine.hasOption((Option)mrOpt);
            if (log.isDebugEnabled()) {
                log.debug("inout     : {}", (Object)dataName);
                log.debug("dataset   : {}", (Object)datasetName);
                log.debug("model     : {}", (Object)modelName);
                log.debug("output    : {}", (Object)outputName);
                log.debug("analyze   : {}", (Object)this.analyze);
                log.debug("mapreduce : {}", (Object)this.useMapreduce);
            }
            this.dataPath = new Path(dataName);
            this.datasetPath = new Path(datasetName);
            this.modelPath = new Path(modelName);
            if (outputName != null) {
                this.outputPath = new Path(outputName);
            }
        }
        catch (OptionException e) {
            log.warn(e.toString(), (Throwable)e);
            CommandLineUtil.printHelp((Group)group);
            return -1;
        }
        this.testForest();
        return 0;
    }

    private void testForest() throws IOException, ClassNotFoundException, InterruptedException {
        FileSystem mfs;
        if (this.outputPath != null) {
            this.outFS = this.outputPath.getFileSystem(this.getConf());
            if (this.outFS.exists(this.outputPath)) {
                throw new IllegalArgumentException("Output path already exists");
            }
        }
        if (!(mfs = this.modelPath.getFileSystem(this.getConf())).exists(this.modelPath)) {
            throw new IllegalArgumentException("The forest path does not exist");
        }
        this.dataFS = this.dataPath.getFileSystem(this.getConf());
        if (!this.dataFS.exists(this.dataPath)) {
            throw new IllegalArgumentException("The Test data path does not exist");
        }
        if (this.useMapreduce) {
            this.mapreduce();
        } else {
            this.sequential();
        }
    }

    private void mapreduce() throws ClassNotFoundException, IOException, InterruptedException {
        double[][] results;
        if (this.outputPath == null) {
            throw new IllegalArgumentException("You must specify the ouputPath when using the mapreduce implementation");
        }
        Classifier classifier = new Classifier(this.modelPath, this.dataPath, this.datasetPath, this.outputPath, this.getConf());
        classifier.run();
        if (this.analyze && (results = classifier.getResults()) != null) {
            Dataset dataset = Dataset.load((Configuration)this.getConf(), (Path)this.datasetPath);
            if (dataset.isNumerical(dataset.getLabelId())) {
                RegressionResultAnalyzer regressionAnalyzer = new RegressionResultAnalyzer();
                regressionAnalyzer.setInstances(results);
                log.info("{}", (Object)regressionAnalyzer);
            } else {
                ResultAnalyzer analyzer = new ResultAnalyzer(Arrays.asList(dataset.labels()), "unknown");
                for (double[] res : results) {
                    analyzer.addInstance(dataset.getLabelString(res[0]), new ClassifierResult(dataset.getLabelString(res[1]), 1.0));
                }
                log.info("{}", (Object)analyzer);
            }
        }
    }

    private void sequential() throws IOException {
        log.info("Loading the forest...");
        DecisionForest forest = DecisionForest.load((Configuration)this.getConf(), (Path)this.modelPath);
        if (forest == null) {
            log.error("No Decision Forest found!");
            return;
        }
        Dataset dataset = Dataset.load((Configuration)this.getConf(), (Path)this.datasetPath);
        DataConverter converter = new DataConverter(dataset);
        log.info("Sequential classification...");
        long time = System.currentTimeMillis();
        RandomWrapper rng = RandomUtils.getRandom();
        ArrayList<double[]> resList = new ArrayList<double[]>();
        if (this.dataFS.getFileStatus(this.dataPath).isDir()) {
            this.testDirectory(this.outputPath, converter, forest, dataset, resList, (Random)rng);
        } else {
            this.testFile(this.dataPath, this.outputPath, converter, forest, dataset, resList, (Random)rng);
        }
        time = System.currentTimeMillis() - time;
        log.info("Classification Time: {}", (Object)DFUtils.elapsedTime((long)time));
        if (this.analyze) {
            if (dataset.isNumerical(dataset.getLabelId())) {
                RegressionResultAnalyzer regressionAnalyzer = new RegressionResultAnalyzer();
                double[][] results = new double[resList.size()][2];
                regressionAnalyzer.setInstances((double[][])resList.toArray((T[])results));
                log.info("{}", (Object)regressionAnalyzer);
            } else {
                ResultAnalyzer analyzer = new ResultAnalyzer(Arrays.asList(dataset.labels()), "unknown");
                for (double[] r : resList) {
                    analyzer.addInstance(dataset.getLabelString(r[0]), new ClassifierResult(dataset.getLabelString(r[1]), 1.0));
                }
                log.info("{}", (Object)analyzer);
            }
        }
    }

    private void testDirectory(Path outPath, DataConverter converter, DecisionForest forest, Dataset dataset, Collection<double[]> results, Random rng) throws IOException {
        Path[] infiles;
        for (Path path : infiles = DFUtils.listOutputFiles((FileSystem)this.dataFS, (Path)this.dataPath)) {
            log.info("Classifying : {}", (Object)path);
            Path outfile = outPath != null ? new Path(outPath, path.getName()).suffix(".out") : null;
            this.testFile(path, outfile, converter, forest, dataset, results, rng);
        }
    }

    private void testFile(Path inPath, Path outPath, DataConverter converter, DecisionForest forest, Dataset dataset, Collection<double[]> results, Random rng) throws IOException {
        FSDataOutputStream ofile = null;
        if (outPath != null) {
            ofile = this.outFS.create(outPath);
        }
        try (FSDataInputStream input = this.dataFS.open(inPath);){
            Scanner scanner = new Scanner((InputStream)input, "UTF-8");
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (line.isEmpty()) continue;
                Instance instance = converter.convert((CharSequence)line);
                double prediction = forest.classify(dataset, rng, instance);
                if (ofile != null) {
                    ofile.writeChars(Double.toString(prediction));
                    ofile.writeChar(10);
                }
                results.add(new double[]{dataset.getLabel(instance), prediction});
            }
            scanner.close();
        }
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Configuration)new Configuration(), (Tool)new TestForest(), (String[])args);
    }
}

