/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.sparkbindings;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStreamReader;
import java.io.StringWriter;
import org.apache.log4j.Logger;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.MatrixWritable;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.drm.BCast;
import org.apache.mahout.math.drm.CacheHint$;
import org.apache.mahout.math.drm.CheckpointedDrm;
import org.apache.mahout.math.drm.DistributedContext;
import org.apache.mahout.math.drm.DrmLike;
import org.apache.mahout.sparkbindings.SparkDistributedContext;
import org.apache.mahout.sparkbindings.drm.CheckpointedDrmSpark;
import org.apache.mahout.sparkbindings.drm.CheckpointedDrmSpark$;
import org.apache.mahout.sparkbindings.drm.CheckpointedDrmSparkOps;
import org.apache.mahout.sparkbindings.drm.DrmRddInput;
import org.apache.mahout.sparkbindings.drm.SparkBCast;
import org.apache.mahout.util.IOUtilsScala$;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.Growable;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class package$ {
    public static final package$ MODULE$;
    private final Logger org$apache$mahout$sparkbindings$package$$log;

    static {
        new package$();
    }

    public final Logger org$apache$mahout$sparkbindings$package$$log() {
        return this.org$apache$mahout$sparkbindings$package$$log;
    }

    public SparkDistributedContext mahoutSparkContext(String masterUrl, String appName, TraversableOnce<String> customJars, SparkConf sparkConf, boolean addMahoutJars) {
        ListBuffer closeables = (ListBuffer)ListBuffer$.MODULE$.empty();
        try {
            SparkConf sparkConf2;
            if (addMahoutJars) {
                ArrayBuffer<String> mcjars = this.findMahoutContextJars((Growable<Closeable>)closeables);
                if (this.org$apache$mahout$sparkbindings$package$$log().isDebugEnabled()) {
                    this.org$apache$mahout$sparkbindings$package$$log().debug((Object)"Mahout jars:");
                    mcjars.foreach((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final void apply(String j) {
                            package$.MODULE$.org$apache$mahout$sparkbindings$package$$log().debug((Object)j);
                        }
                    });
                }
                sparkConf2 = sparkConf.setJars((Seq)mcjars.toSeq().$plus$plus(customJars, Seq$.MODULE$.canBuildFrom()));
            } else {
                sparkConf2 = sparkConf.setJars(customJars.toSeq());
            }
            sparkConf.setAppName(appName).setMaster(masterUrl).set("spark.serializer", "org.apache.spark.serializer.KryoSerializer").set("spark.kryo.registrator", "org.apache.mahout.sparkbindings.io.MahoutKryoRegistrator");
            Object object = System.getenv("SPARK_HOME") == null ? BoxedUnit.UNIT : sparkConf.setSparkHome(System.getenv("SPARK_HOME"));
            return new SparkDistributedContext(new SparkContext(sparkConf));
        }
        finally {
            IOUtilsScala$.MODULE$.close((Seq)closeables);
        }
    }

    public TraversableOnce<String> mahoutSparkContext$default$3() {
        return Nil$.MODULE$;
    }

    public SparkConf mahoutSparkContext$default$4() {
        return new SparkConf();
    }

    public boolean mahoutSparkContext$default$5() {
        return true;
    }

    public SparkContext sdc2sc(SparkDistributedContext sdc) {
        return sdc.sc();
    }

    public SparkDistributedContext sc2sdc(SparkContext sc) {
        return new SparkDistributedContext(sc);
    }

    public SparkContext dc2sc(DistributedContext dc) {
        Predef$.MODULE$.assert(dc instanceof SparkDistributedContext, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "distributed context must be Spark-specific.";
            }
        });
        return this.sdc2sc((SparkDistributedContext)dc);
    }

    public <T> BCast<T> sb2bc(Broadcast<T> b) {
        return new SparkBCast<T>(b);
    }

    public <K> CheckpointedDrmSparkOps<K> cpDrm2cpDrmSparkOps(CheckpointedDrm<K> drm) {
        return new CheckpointedDrmSparkOps<K>(drm);
    }

    public <K> CheckpointedDrmSparkOps<K> drm2cpDrmSparkOps(DrmLike<K> drm) {
        return this.cpDrm2cpDrmSparkOps(org.apache.mahout.math.drm.package$.MODULE$.drm2Checkpointed(drm));
    }

    public MatrixWritable m2w(Matrix m) {
        return new MatrixWritable(m);
    }

    public Matrix w2m(MatrixWritable w) {
        return w.get();
    }

    public VectorWritable v2w(Vector v) {
        return new VectorWritable(v);
    }

    public Vector w2v(VectorWritable w) {
        return w.get();
    }

    public <K> CheckpointedDrm<K> drmWrap(RDD<Tuple2<K, Vector>> rdd, long nrow, int ncol, Enumeration.Value cacheHint, boolean canHaveMissingRows, ClassTag<K> evidence$1) {
        DrmRddInput<K> x$3 = org.apache.mahout.sparkbindings.drm.package$.MODULE$.drmRdd2drmRddInput(rdd, evidence$1);
        long x$4 = nrow;
        int x$5 = ncol;
        Enumeration.Value x$6 = cacheHint;
        boolean x$7 = canHaveMissingRows;
        long x$8 = CheckpointedDrmSpark$.MODULE$.$lessinit$greater$default$5();
        return new CheckpointedDrmSpark<K>(x$3, x$4, x$5, x$6, x$8, x$7, evidence$1);
    }

    public <K> long drmWrap$default$2() {
        return -1L;
    }

    public <K> int drmWrap$default$3() {
        return -1;
    }

    public <K> Enumeration.Value drmWrap$default$4() {
        return CacheHint$.MODULE$.NONE();
    }

    public <K> boolean drmWrap$default$5() {
        return false;
    }

    public <K> CheckpointedDrm<K> drmWrapBlockified(RDD<Tuple2<Object, Matrix>> blockifiedDrmRdd, long nrow, int ncol, Enumeration.Value cacheHint, boolean canHaveMissingRows, ClassTag<K> evidence$2) {
        return this.drmWrap(org.apache.mahout.sparkbindings.drm.package$.MODULE$.deblockify(blockifiedDrmRdd, evidence$2), nrow, ncol, cacheHint, canHaveMissingRows, evidence$2);
    }

    public <K> long drmWrapBlockified$default$2() {
        return -1L;
    }

    public <K> int drmWrapBlockified$default$3() {
        return -1;
    }

    public <K> Enumeration.Value drmWrapBlockified$default$4() {
        return CacheHint$.MODULE$.NONE();
    }

    public <K> boolean drmWrapBlockified$default$5() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public String getMahoutHome() {
        void var1_1;
        String mhome = System.getenv("MAHOUT_HOME");
        if (mhome == null) {
            mhome = System.getProperty("mahout.home");
        }
        Predef$.MODULE$.require(mhome != null, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "MAHOUT_HOME is required to spawn mahout-based spark jobs";
            }
        });
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ArrayBuffer<String> findMahoutContextJars(Growable<Closeable> closeables) {
        void var4_4;
        File fmhome = new File(this.getMahoutHome());
        File bin = new File(fmhome, "bin");
        File exec2 = new File(bin, "mahout");
        if (exec2.canExecute()) {
            Process p = Runtime.getRuntime().exec((String[])((Object[])new String[]{exec2.getAbsolutePath(), "-spark", "classpath"}));
            closeables.$plus$eq((Object)new Closeable(p){
                private final Process p$1;

                public void close() {
                    this.p$1.destroy();
                }
                {
                    this.p$1 = p$1;
                }
            });
            BufferedReader r = new BufferedReader(new InputStreamReader(p.getInputStream()));
            closeables.$plus$eq((Object)r);
            StringWriter w = new StringWriter();
            closeables.$plus$eq((Object)w);
            boolean bl = true;
            ArrayBuffer jars = new ArrayBuffer();
            do {
                String cp;
                if ((cp = r.readLine()) == null) {
                    throw new IllegalArgumentException("Unable to read output from \"mahout -spark classpath\". Is SPARK_HOME defined?");
                }
                String[] j = new StringOps(Predef$.MODULE$.augmentString(cp)).split(File.pathSeparatorChar);
                if (j.length <= 10) continue;
                jars.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])j));
                bl = false;
            } while (bl);
            ArrayBuffer mcjars = (ArrayBuffer)((TraversableLike)jars.filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String j) {
                    return j.matches(".*mahout-math-\\d.*\\.jar") || j.matches(".*mahout-math-scala_\\d.*\\.jar") || j.matches(".*mahout-hdfs-\\d.*\\.jar") || j.matches(".*mahout-spark_\\d.*\\.jar");
                }
            })).filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String n) {
                    return !n.matches(".*-tests.jar") && !n.matches(".*-sources.jar") && !n.matches(".*-job.jar") && !n.matches(".*/.m2/.*");
                }
            });
            return mcjars;
        }
        throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Cannot execute %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var4_4.getAbsolutePath()})));
    }

    public <K> boolean validateBlockifiedDrmRdd(RDD<Tuple2<Object, Matrix>> rdd) {
        boolean part1Req = BoxesRunTime.unboxToBoolean((Object)rdd.mapPartitions((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterator<Object> apply(Iterator<Tuple2<Object, Matrix>> piter) {
                return Iterator$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{piter.size() == 1}));
            }
        }, rdd.mapPartitions$default$2(), ClassTag$.MODULE$.Boolean()).reduce((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(boolean x$1, boolean x$2) {
                return x$1 && x$2;
            }
        }));
        if (!part1Req) {
            org.apache.mahout.logging.package$.MODULE$.warn((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "blockified rdd: condition not met: exactly 1 per partition";
                }
            }, this.org$apache$mahout$sparkbindings$package$$log());
        }
        return part1Req;
    }

    private package$() {
        MODULE$ = this;
        this.org$apache$mahout$sparkbindings$package$$log = org.apache.mahout.logging.package$.MODULE$.getLog(this.getClass());
    }
}

